/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.query.response;

import cn.schoolwow.quickdao.domain.ConnectionExecutorItem;
import cn.schoolwow.quickdao.domain.PageVo;
import cn.schoolwow.quickdao.domain.Property;
import cn.schoolwow.quickdao.domain.Query;
import cn.schoolwow.quickdao.domain.SubQuery;
import cn.schoolwow.quickdao.exception.SQLRuntimeException;
import cn.schoolwow.quickdao.query.response.AbstractResponse;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class OracleResponse<T>
extends AbstractResponse<T> {
    public OracleResponse(Query query) {
        super(query);
    }

    @Override
    public List getList() {
        return this.getList(this.getResponseQuery().entity.clazz);
    }

    @Override
    public PageVo<T> getPagingList() {
        return this.getPagingList(this.getResponseQuery().entity.clazz);
    }

    @Override
    public JSONArray getArray() {
        JSONArray array = null;
        try {
            array = new JSONArray(this.query.dqlBuilder.getResultSetRowCount(this.query));
            ConnectionExecutorItem connectionExecutorItem = this.query.dqlBuilder.getArray(this.query);
            ResultSet resultSet = this.query.dqlBuilder.connectionExecutor.executeQuery(connectionExecutorItem);
            Query query = this.getResponseQuery();
            if (query.column.length() > 0) {
                if (null == query.columnTypeMapping) {
                    query.columnTypeMapping = query.quickDAOConfig.columnTypeMapping;
                }
                ResultSetMetaData metaData = resultSet.getMetaData();
                Property[] properties = new Property[metaData.getColumnCount()];
                for (int i = 1; i <= properties.length; ++i) {
                    Class type;
                    properties[i - 1] = new Property();
                    properties[i - 1].columnLabel = metaData.getColumnLabel(i);
                    properties[i - 1].column = metaData.getColumnName(i);
                    properties[i - 1].columnType = metaData.getColumnTypeName(i);
                    properties[i - 1].className = metaData.getColumnClassName(i);
                    if (null == query.columnTypeMapping || null == (type = query.columnTypeMapping.columnMappingType(properties[i - 1]))) continue;
                    properties[i - 1].clazz = type;
                }
                while (resultSet.next()) {
                    JSONObject o = new JSONObject(true);
                    for (int i = 1; i <= properties.length; ++i) {
                        if (null == properties[i - 1].clazz) {
                            o.put(properties[i - 1].columnLabel, resultSet.getObject(i));
                            continue;
                        }
                        o.put(properties[i - 1].columnLabel, resultSet.getObject(i, properties[i - 1].clazz));
                    }
                    array.add((Object)o);
                }
            } else {
                while (resultSet.next()) {
                    JSONObject o = query.quickDAOConfig.database.getObject(query.entity, query.tableAliasName, resultSet);
                    if (query.compositField) {
                        this.getCompositObject(resultSet, o, query);
                    }
                    array.add((Object)o);
                }
            }
            resultSet.close();
            connectionExecutorItem.preparedStatement.close();
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
        return array;
    }

    private void getCompositObject(ResultSet resultSet, JSONObject o, Query query) throws SQLException {
        for (SubQuery subQuery : query.subQueryList) {
            if (null == subQuery.compositField || subQuery.compositField.isEmpty()) continue;
            JSONObject subObject = query.quickDAOConfig.database.getObject(subQuery.entity, subQuery.tableAliasName, resultSet);
            SubQuery parentSubQuery = subQuery.parentSubQuery;
            if (parentSubQuery == null) {
                o.put(subQuery.compositField, (Object)subObject);
                continue;
            }
            ArrayList<String> fieldNames = new ArrayList<String>();
            while (parentSubQuery != null) {
                fieldNames.add(parentSubQuery.compositField);
                parentSubQuery = parentSubQuery.parentSubQuery;
            }
            JSONObject oo = o;
            for (int i = fieldNames.size() - 1; i >= 0; --i) {
                oo = oo.getJSONObject((String)fieldNames.get(i));
            }
            oo.put(subQuery.compositField, (Object)subObject);
        }
    }

    private Query getResponseQuery() {
        if ("where rn >= ?".equals(this.query.where)) {
            return this.query.fromQuery.fromQuery;
        }
        return this.query;
    }
}

