/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.transaction;

import cn.schoolwow.quickdao.dao.sql.ddl.AbstractDDLDAO;
import cn.schoolwow.quickdao.dao.sql.dml.AbstractDMLDAO;
import cn.schoolwow.quickdao.domain.ConnectionExecutor;
import cn.schoolwow.quickdao.domain.QuickDAOConfig;
import cn.schoolwow.quickdao.query.AbstractCompositQuery;
import cn.schoolwow.quickdao.query.CompositQuery;
import cn.schoolwow.quickdao.query.condition.AbstractCondition;
import cn.schoolwow.quickdao.transaction.AbstractTransactionOperation;
import cn.schoolwow.quickdao.transaction.TransactionOperation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionInvocationHandler
implements InvocationHandler {
    private Logger logger = LoggerFactory.getLogger(TransactionInvocationHandler.class);
    private QuickDAOConfig quickDAOConfig;
    private TransactionOperation transactionOperation;
    private CompositQuery compositQuery;
    private AbstractDDLDAO ddldao;
    private AbstractDMLDAO dmldao;
    private Connection connection;

    public TransactionInvocationHandler(QuickDAOConfig quickDAOConfig, Connection connection) {
        this.quickDAOConfig = quickDAOConfig;
        this.transactionOperation = new AbstractTransactionOperation(connection);
        this.compositQuery = new AbstractCompositQuery(quickDAOConfig);
        this.ddldao = new AbstractDDLDAO(quickDAOConfig);
        this.ddldao.sqlBuilder.connectionExecutor = new ConnectionExecutor(quickDAOConfig);
        this.ddldao.sqlBuilder.connectionExecutor.connection = connection;
        this.dmldao = new AbstractDMLDAO(quickDAOConfig);
        this.dmldao.sqlBuilder.connectionExecutor = new ConnectionExecutor(quickDAOConfig);
        this.dmldao.sqlBuilder.connectionExecutor.connection = connection;
        this.connection = connection;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String interfaceName = method.getDeclaringClass().getSimpleName();
        Object result = null;
        try {
            switch (interfaceName) {
                case "CompositQuery": {
                    result = method.invoke((Object)this.compositQuery, args);
                    AbstractCondition abstractCondition = (AbstractCondition)result;
                    abstractCondition.query.transaction = true;
                    abstractCondition.query.dqlBuilder.connectionExecutor = new ConnectionExecutor(this.quickDAOConfig);
                    abstractCondition.query.dqlBuilder.connectionExecutor.connection = this.connection;
                    break;
                }
                case "DDLDAO": {
                    result = method.invoke((Object)this.ddldao, args);
                    break;
                }
                case "DMLDAO": {
                    result = method.invoke((Object)this.dmldao, args);
                    break;
                }
                default: {
                    result = method.invoke((Object)this.transactionOperation, args);
                }
            }
            return result;
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }
}

