/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao;

import cn.schoolwow.quickdao.annotation.IdStrategy;
import cn.schoolwow.quickdao.dao.DAO;
import cn.schoolwow.quickdao.dao.DAOInvocationHandler;
import cn.schoolwow.quickdao.domain.external.Entity;
import cn.schoolwow.quickdao.domain.external.Property;
import cn.schoolwow.quickdao.domain.external.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.external.dml.CheckStrategy;
import cn.schoolwow.quickdao.domain.external.dql.QueryColumnTypeMapping;
import cn.schoolwow.quickdao.domain.external.entity.DatabaseUpgrade;
import cn.schoolwow.quickdao.domain.external.entity.EntityListener;
import cn.schoolwow.quickdao.domain.external.entity.SqlLog;
import cn.schoolwow.quickdao.domain.external.generator.IDGenerator;
import cn.schoolwow.quickdao.entity.TableDefiner;
import cn.schoolwow.quickdao.entity.TableDefinerImpl;
import cn.schoolwow.quickdao.exception.SQLRuntimeException;
import cn.schoolwow.quickdao.flow.entity.SetEntityMapFlow;
import cn.schoolwow.quickdao.flow.handler.QuickDAOTryCatchFinallyHandler;
import cn.schoolwow.quickdao.flow.initial.AfterAutomaticCreateFlow;
import cn.schoolwow.quickdao.flow.initial.AutomaticCreateColumnFlow;
import cn.schoolwow.quickdao.flow.initial.AutomaticCreateTableFlow;
import cn.schoolwow.quickdao.flow.initial.AutomaticDeleteTableAndPropertyFlow;
import cn.schoolwow.quickdao.flow.initial.AutomaticUpdatePropertyFlow;
import cn.schoolwow.quickdao.flow.initial.BeforeAutomaticCreateFlow;
import cn.schoolwow.quickdao.flow.initial.LogRecordFlow;
import cn.schoolwow.quickdao.flow.initial.datasource.AutomaticCreateDatabase;
import cn.schoolwow.quickdao.provider.DatabaseProvider;
import cn.schoolwow.quickdao.provider.H2DatabaseProvider;
import cn.schoolwow.quickdao.provider.MariaDBDatabaseProvider;
import cn.schoolwow.quickdao.provider.MySQLDatabaseProvider;
import cn.schoolwow.quickdao.provider.OracleDatabaseProvider;
import cn.schoolwow.quickdao.provider.PostgresDatabaseProvider;
import cn.schoolwow.quickdao.provider.SQLServerDatabaseProvider;
import cn.schoolwow.quickdao.provider.SQLiteDatabaseProvider;
import cn.schoolwow.quickflow.QuickFlowBuilder;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import cn.schoolwow.quickflow.listener.TryCatchFinallyHandler;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuickDAO {
    private Logger logger = LoggerFactory.getLogger(QuickDAO.class);
    private static List<DatabaseProvider> databaseProviderList = new ArrayList<DatabaseProvider>(Arrays.asList(new H2DatabaseProvider(), new MariaDBDatabaseProvider(), new MySQLDatabaseProvider(), new OracleDatabaseProvider(), new PostgresDatabaseProvider(), new SQLiteDatabaseProvider(), new SQLServerDatabaseProvider()));
    private QuickDAOConfig quickDAOConfig = new QuickDAOConfig();

    public static List<DatabaseProvider> getDatabaseProviderList() {
        return databaseProviderList;
    }

    public static void addDatabaseProvider(DatabaseProvider databaseProvider) {
        databaseProviderList.add(databaseProvider);
    }

    public static QuickDAO newInstance() {
        return new QuickDAO();
    }

    private QuickDAO() {
    }

    public QuickDAO dataSource(DataSource dataSource) {
        QuickFlowBuilder.defaultQuickFlow().startFlow((BusinessFlow)new AutomaticCreateDatabase()).putCurrentCompositeFlowData("databaseProviderList", databaseProviderList).putCurrentCompositeFlowData("quickDAOConfig", (Object)this.quickDAOConfig).putCurrentCompositeFlowData("dataSource", (Object)dataSource).execute();
        try (Connection connection = dataSource.getConnection();){
            connection.setAutoCommit(false);
            String jdbcUrl = connection.getMetaData().getURL();
            for (DatabaseProvider databaseProvider : databaseProviderList) {
                if (!jdbcUrl.contains("jdbc:" + databaseProvider.name())) continue;
                this.quickDAOConfig.databaseContext.databaseProvider = databaseProvider;
                break;
            }
            if (null == this.quickDAOConfig.databaseContext.databaseProvider) {
                throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u6570\u636e\u5e93\u7c7b\u578b!jdbcUrl:" + jdbcUrl);
            }
            this.quickDAOConfig.databaseContext.databaseName = connection.getCatalog();
            this.logger.info("[\u6570\u636e\u6e90]\u7c7b\u578b:{},\u5730\u5740:{}", (Object)this.quickDAOConfig.databaseContext.databaseProvider.name(), (Object)jdbcUrl);
        }
        catch (Exception e) {
            throw new SQLRuntimeException(e);
        }
        this.quickDAOConfig.databaseContext.dataSource = dataSource;
        return this;
    }

    public QuickDAO packageName(String packageName) {
        this.quickDAOConfig.entityOption.packageNameMap.put(packageName, "");
        return this;
    }

    public QuickDAO packageName(String packageName, String prefix) {
        this.quickDAOConfig.entityOption.packageNameMap.put(packageName, prefix + "_");
        return this;
    }

    public QuickDAO entity(Class ... entityClasses) {
        for (Class entityClass : entityClasses) {
            this.quickDAOConfig.entityOption.entityClassMap.put(entityClass, "");
        }
        return this;
    }

    public QuickDAO entity(Class entityClass, String prefix) {
        this.quickDAOConfig.entityOption.entityClassMap.put(entityClass, prefix);
        return this;
    }

    public QuickDAO ignorePackageName(String ignorePackageName) {
        if (this.quickDAOConfig.entityOption.ignorePackageNameList == null) {
            this.quickDAOConfig.entityOption.ignorePackageNameList = new ArrayList<String>();
        }
        this.quickDAOConfig.entityOption.ignorePackageNameList.add(ignorePackageName);
        return this;
    }

    public QuickDAO ignoreClass(Class ignoreClass) {
        if (this.quickDAOConfig.entityOption.ignoreClassList == null) {
            this.quickDAOConfig.entityOption.ignoreClassList = new ArrayList<Class>();
        }
        this.quickDAOConfig.entityOption.ignoreClassList.add(ignoreClass);
        return this;
    }

    public QuickDAO filter(Predicate<Class> ignorePredicate) {
        this.quickDAOConfig.entityOption.ignorePredicate = ignorePredicate;
        return this;
    }

    public QuickDAO foreignKey(boolean openForeignKey) {
        this.quickDAOConfig.databaseOption.openForeignKey = openForeignKey;
        return this;
    }

    public QuickDAO automaticCreateTable(boolean autoCreateTable) {
        this.quickDAOConfig.databaseOption.automaticCreateTable = autoCreateTable;
        return this;
    }

    public QuickDAO automaticCreateProperty(boolean autoCreateProperty) {
        this.quickDAOConfig.databaseOption.automaticCreateProperty = autoCreateProperty;
        return this;
    }

    public QuickDAO automaticUpdateProperty(boolean automaticUpdateProperty) {
        this.quickDAOConfig.databaseOption.automaticUpdateProperty = automaticUpdateProperty;
        return this;
    }

    public QuickDAO updateTableName(String ... updateTableNames) {
        this.quickDAOConfig.databaseOption.updateTableNameList.addAll(Arrays.asList(updateTableNames));
        return this;
    }

    public QuickDAO automaticDeleteTableAndProperty(boolean autoDeleteTableAndProperty) {
        this.quickDAOConfig.databaseOption.automaticDeleteTableAndProperty = autoDeleteTableAndProperty;
        return this;
    }

    public QuickDAO idStrategy(IdStrategy idStrategy) {
        this.quickDAOConfig.databaseOption.idStrategy = idStrategy;
        return this;
    }

    public QuickDAO idGenerator(IDGenerator idGenerator) {
        this.quickDAOConfig.databaseOption.idGenerator = idGenerator;
        return this;
    }

    public QuickDAO queryColumnTypeMapping(QueryColumnTypeMapping queryColumnTypeMapping) {
        this.quickDAOConfig.entityOption.queryColumnTypeMapping = queryColumnTypeMapping;
        return this;
    }

    public QuickDAO perBatchCount(int perBatchCount) {
        this.quickDAOConfig.databaseOption.perBatchCount = perBatchCount;
        return this;
    }

    public QuickDAO insertColumnValueFunction(Function<Property, Object> insertColumnValueFunction) {
        this.quickDAOConfig.databaseOption.insertColumnValueFunction = insertColumnValueFunction;
        return this;
    }

    public QuickDAO updateColumnValueFunction(Function<Property, Object> updateColumnValueFunction) {
        this.quickDAOConfig.databaseOption.updateColumnValueFunction = updateColumnValueFunction;
        return this;
    }

    public QuickDAO virtualTableName(String ... virtualTableNames) {
        this.quickDAOConfig.databaseOption.virtualTableNameList.addAll(Arrays.asList(virtualTableNames));
        return this;
    }

    public QuickDAO recordSqlLog(boolean recordSqlLog) {
        this.quickDAOConfig.logRecordOption.recordSqlLog = recordSqlLog;
        return this;
    }

    public QuickDAO recordFlowLog(boolean recordFlowLog) {
        this.quickDAOConfig.logRecordOption.recordFlowLog = recordFlowLog;
        return this;
    }

    public QuickDAO checkStrategy(CheckStrategy checkStrategy) {
        this.quickDAOConfig.databaseOption.checkStrategy = checkStrategy;
        return this;
    }

    public TableDefiner define(Class clazz) {
        if (null == this.quickDAOConfig.databaseContext.dataSource) {
            throw new IllegalArgumentException("\u8bf7\u5148\u8c03\u7528dataSource\u65b9\u6cd5\u914d\u7f6e\u6570\u636e\u6e90!");
        }
        Entity entity = new Entity();
        entity.clazz = clazz;
        this.quickDAOConfig.entityOption.definerEntityMap.put(clazz.getName(), entity);
        return new TableDefinerImpl(entity, this);
    }

    public QuickDAO beforeAutomaticCreate(String name, Consumer<DAO> daoConsumer) {
        if (this.quickDAOConfig.upgradeOption.beforeAutomaticCreate.containsKey(name)) {
            throw new IllegalArgumentException("\u5347\u7ea7\u8bed\u53e5\u540d\u79f0\u91cd\u590d!\u540d\u79f0:" + name);
        }
        this.quickDAOConfig.upgradeOption.beforeAutomaticCreate.put(name, daoConsumer);
        return this;
    }

    public QuickDAO afterAutomaticCreate(String name, Consumer<DAO> daoConsumer) {
        if (this.quickDAOConfig.upgradeOption.afterAutomaticCreate.containsKey(name)) {
            throw new IllegalArgumentException("\u5347\u7ea7\u8bed\u53e5\u540d\u79f0\u91cd\u590d!\u540d\u79f0:" + name);
        }
        this.quickDAOConfig.upgradeOption.afterAutomaticCreate.put(name, daoConsumer);
        return this;
    }

    public QuickDAO entityListener(EntityListener entityListener) {
        this.quickDAOConfig.entityOption.entityListener = entityListener;
        return this;
    }

    public DAO build() {
        if (null == this.quickDAOConfig.databaseContext.databaseProvider) {
            throw new IllegalArgumentException("\u8bf7\u5148\u8c03\u7528dataSource\u65b9\u6cd5\u914d\u7f6e\u6570\u636e\u6e90!");
        }
        this.quickDAOConfig.quickFlow = QuickFlowBuilder.newInstance().printTrace(this.quickDAOConfig.logRecordOption.recordFlowLog).executeGlobalTryCatchFinally(true).tryCatchFinallyHandler((TryCatchFinallyHandler)new QuickDAOTryCatchFinallyHandler(null, this.quickDAOConfig));
        DAOInvocationHandler daoInvocationHandler = new DAOInvocationHandler(this.quickDAOConfig.quickFlow, this.quickDAOConfig);
        DAO daoProxy = (DAO)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{DAO.class}, (InvocationHandler)daoInvocationHandler);
        this.entity(SqlLog.class);
        this.entity(DatabaseUpgrade.class);
        this.quickDAOConfig.dao = daoProxy;
        this.quickDAOConfig.quickFlow.startFlow("\u521d\u59cb\u5316DAO\u5bf9\u8c61").putTemporaryData("dao", (Object)daoProxy).next((BusinessFlow)new SetEntityMapFlow()).next((BusinessFlow)new LogRecordFlow()).next((BusinessFlow)new BeforeAutomaticCreateFlow()).next((BusinessFlow)new AutomaticDeleteTableAndPropertyFlow()).next((BusinessFlow)new AutomaticCreateTableFlow()).next((BusinessFlow)new AutomaticCreateColumnFlow()).next((BusinessFlow)new AutomaticUpdatePropertyFlow()).next((BusinessFlow)new AfterAutomaticCreateFlow()).execute();
        return daoProxy;
    }
}

