/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.dao.ddl;

import cn.schoolwow.quickdao.dao.ddl.DatabaseDefinition;
import cn.schoolwow.quickdao.dao.sql.DatabaseDAOImpl;
import cn.schoolwow.quickdao.domain.external.Entity;
import cn.schoolwow.quickdao.domain.external.IndexField;
import cn.schoolwow.quickdao.domain.external.Property;
import cn.schoolwow.quickdao.domain.external.PropertyOption;
import cn.schoolwow.quickdao.domain.external.QuickDAOConfig;
import cn.schoolwow.quickdao.flow.ddl.common.DeleteDatabaseEntityCacheFlow;
import cn.schoolwow.quickdao.flow.ddl.common.GetDatabaseEntityFromCacheFlow;
import cn.schoolwow.quickdao.flow.ddl.common.SaveDatabaseEntityToCacheFlow;
import cn.schoolwow.quickdao.flow.ddl.createTable.CreateTableFlow;
import cn.schoolwow.quickdao.flow.ddl.has.HasConstraintFlow;
import cn.schoolwow.quickdao.flow.ddl.has.HasIndexFlow;
import cn.schoolwow.quickdao.flow.ddl.has.HasTableColumnFlow;
import cn.schoolwow.quickdao.flow.ddl.has.HasTableFlow;
import cn.schoolwow.quickdao.flow.ddl.index.CreateIndexFlow;
import cn.schoolwow.quickdao.flow.ddl.index.DropIndexFlow;
import cn.schoolwow.quickdao.flow.ddl.index.GetEntityIndexFlow;
import cn.schoolwow.quickdao.flow.ddl.index.GetEntityIndexListFlow;
import cn.schoolwow.quickdao.flow.ddl.index.GetSingleEntityIndexFlow;
import cn.schoolwow.quickdao.flow.ddl.property.AlterTableColumnFlow;
import cn.schoolwow.quickdao.flow.ddl.property.CreateTableColumnFlow;
import cn.schoolwow.quickdao.flow.ddl.property.DropTableColumnFlow;
import cn.schoolwow.quickdao.flow.ddl.property.GetEntityPropertyFlow;
import cn.schoolwow.quickdao.flow.ddl.property.GetEntityPropertyListFlow;
import cn.schoolwow.quickdao.flow.ddl.property.GetPropertyFlow;
import cn.schoolwow.quickdao.flow.ddl.property.RenameTableColumnFlow;
import cn.schoolwow.quickdao.flow.ddl.table.BackupTableFlow;
import cn.schoolwow.quickdao.flow.ddl.table.CreateForeignKeyFlow;
import cn.schoolwow.quickdao.flow.ddl.table.DropTableFlow;
import cn.schoolwow.quickdao.flow.ddl.table.EnableForeignConstraintCheckFlow;
import cn.schoolwow.quickdao.flow.ddl.table.GetEntityFlow;
import cn.schoolwow.quickdao.flow.ddl.table.GetEntityListFlow;
import cn.schoolwow.quickdao.flow.ddl.table.GetTableNameListFlow;
import cn.schoolwow.quickdao.flow.ddl.table.RenameTableFlow;
import cn.schoolwow.quickflow.QuickFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseDefinitionImpl
extends DatabaseDAOImpl
implements DatabaseDefinition {
    protected Logger logger = LoggerFactory.getLogger(DatabaseDefinitionImpl.class);

    public DatabaseDefinitionImpl(QuickFlow quickFlow, QuickDAOConfig quickDAOConfig) {
        super(quickFlow, quickDAOConfig);
    }

    @Override
    public boolean hasTable(Class clazz) {
        Entity entity = this.quickDAOConfig.getEntityByClassName(clazz.getName());
        return this.hasTable(entity.tableName);
    }

    @Override
    public boolean hasTable(String tableName) {
        FlowContext flowContext = this.quickFlow.startFlow((BusinessFlow)new HasTableFlow()).putTemporaryData("tableName", (Object)tableName).execute();
        boolean hasResult = (Boolean)flowContext.checkData("hasResult");
        return hasResult;
    }

    @Override
    public boolean hasColumn(Class clazz, String columnName) {
        FlowContext flowContext = this.quickFlow.startFlow((BusinessFlow)new HasTableColumnFlow()).putTemporaryData("clazz", (Object)clazz).putTemporaryData("columnName", (Object)columnName).execute();
        boolean hasResult = (Boolean)flowContext.checkData("hasResult");
        return hasResult;
    }

    @Override
    public boolean hasColumn(String tableName, String columnName) {
        FlowContext flowContext = this.quickFlow.startFlow((BusinessFlow)new HasTableColumnFlow()).putTemporaryData("tableName", (Object)tableName).putTemporaryData("columnName", (Object)columnName).execute();
        boolean hasResult = (Boolean)flowContext.checkData("hasResult");
        return hasResult;
    }

    @Override
    public List<String> getTableNameList() {
        FlowContext flowContext = this.quickFlow.executeFlow(new BusinessFlow[]{new GetTableNameListFlow()});
        List tableNameList = (List)flowContext.getData("tableNameList");
        return tableNameList;
    }

    @Override
    public List<Entity> getDatabaseEntityList() {
        FlowContext flowContext = this.quickFlow.startFlow("\u83b7\u53d6\u6570\u636e\u5e93\u6240\u6709\u8868\u4fe1\u606f").next((BusinessFlow)new GetDatabaseEntityFromCacheFlow()).next((BusinessFlow)new GetEntityListFlow()).next((BusinessFlow)new GetEntityPropertyListFlow()).next((BusinessFlow)new GetEntityIndexListFlow()).next((BusinessFlow)new SaveDatabaseEntityToCacheFlow()).execute();
        List entityList = (List)flowContext.getData("entityList");
        return entityList;
    }

    @Override
    public Entity getDatabaseEntity(String tableName) {
        FlowContext flowContext = this.quickFlow.startFlow("\u83b7\u53d6\u6570\u636e\u5e93\u6307\u5b9a\u8868\u4fe1\u606f").putTemporaryData("tableName", (Object)tableName).next((BusinessFlow)new GetDatabaseEntityFromCacheFlow()).next((BusinessFlow)new GetEntityFlow()).next((BusinessFlow)new GetEntityPropertyFlow()).next((BusinessFlow)new GetEntityIndexFlow()).next((BusinessFlow)new SaveDatabaseEntityToCacheFlow()).execute();
        Entity entity = (Entity)flowContext.getData("entity");
        return entity;
    }

    @Override
    public List<Property> getPropertyList(Class clazz) {
        Entity entity = this.quickDAOConfig.getEntityByClassName(clazz.getName());
        return this.getPropertyList(entity.tableName);
    }

    @Override
    public List<Property> getPropertyList(String tableName) {
        Entity entity = new Entity();
        entity.tableName = tableName;
        FlowContext flowContext = this.quickFlow.startFlow("\u83b7\u53d6\u6570\u636e\u5e93\u8868\u5b57\u6bb5\u4fe1\u606f").putTemporaryData("tableName", (Object)tableName).putTemporaryData("entity", (Object)entity).next((BusinessFlow)new GetDatabaseEntityFromCacheFlow()).next((BusinessFlow)new GetEntityPropertyFlow()).execute();
        entity = (Entity)flowContext.checkData("entity");
        return entity.properties;
    }

    @Override
    public Property getProperty(Class clazz, String columnName) {
        Entity entity = this.quickDAOConfig.getEntityByClassName(clazz.getName());
        return this.getProperty(entity.tableName, entity.getColumnNameByFieldName(columnName));
    }

    @Override
    public Property getProperty(String tableName, String columnName) {
        FlowContext flowContext = this.quickFlow.startFlow("\u83b7\u53d6\u6570\u636e\u5e93\u8868\u6307\u5b9a\u5b57\u6bb5\u4fe1\u606f").putTemporaryData("tableName", (Object)tableName).putTemporaryData("columnName", (Object)columnName).next((BusinessFlow)new GetDatabaseEntityFromCacheFlow()).next((BusinessFlow)new GetPropertyFlow()).execute();
        Property property = (Property)flowContext.getData("property");
        if (null == property) {
            throw new IllegalArgumentException("\u6307\u5b9a\u8868\u7684\u6307\u5b9a\u5b57\u6bb5\u4e0d\u5b58\u5728!\u8868\u540d:" + tableName + ",\u5b57\u6bb5\u540d:" + columnName);
        }
        return property;
    }

    @Override
    public void create(Class clazz) {
        Entity entity = this.quickDAOConfig.getEntityByClassName(clazz.getName());
        this.create(entity);
    }

    @Override
    public void create(Entity entity) {
        this.quickFlow.startFlow((BusinessFlow)new CreateTableFlow()).putTemporaryData("entity", (Object)entity).execute();
    }

    @Override
    public void renameTable(String oldTableName, String newTableName) {
        this.quickFlow.startFlow((BusinessFlow)new RenameTableFlow()).next((BusinessFlow)new DeleteDatabaseEntityCacheFlow()).putTemporaryData("oldTableName", (Object)oldTableName).putTemporaryData("newTableName", (Object)newTableName).putTemporaryData("tableName", (Object)oldTableName).execute();
    }

    @Override
    public void dropTable(Class clazz) {
        Entity entity = this.quickDAOConfig.getEntityByClassName(clazz.getName());
        this.dropTable(entity.tableName);
    }

    @Override
    public void dropTable(String tableName) {
        this.quickFlow.startFlow((BusinessFlow)new DropTableFlow()).next((BusinessFlow)new DeleteDatabaseEntityCacheFlow()).putTemporaryData("tableName", (Object)tableName).execute();
    }

    @Override
    public void rebuild(Class clazz) {
        if (this.hasTable(clazz)) {
            this.dropTable(clazz);
        }
        this.create(clazz);
    }

    @Override
    public void rebuild(String tableName) {
        if (this.hasTable(tableName)) {
            this.dropTable(tableName);
        }
        Entity entity = this.quickDAOConfig.getDatabaseEntityByTableName(tableName);
        this.create(entity);
    }

    @Override
    public Property createColumn(String tableName, PropertyOption propertyOption) {
        FlowContext flowContext = this.quickFlow.startFlow("\u65b0\u589e\u8868\u5b57\u6bb5").ignoreBroken(false).next((BusinessFlow)new HasTableFlow()).next((BusinessFlow)new CreateTableColumnFlow()).next((BusinessFlow)new DeleteDatabaseEntityCacheFlow()).next((BusinessFlow)new GetPropertyFlow()).putTemporaryData("tableName", (Object)tableName).putTemporaryData("propertyOption", (Object)propertyOption).putTemporaryData("columnName", (Object)propertyOption.column).execute();
        Property property = (Property)flowContext.checkData("property");
        return property;
    }

    @Override
    public void renameTableColumn(String tableName, String oldTableColumn, String newTableColumn) {
        this.quickFlow.startFlow((BusinessFlow)new RenameTableColumnFlow()).next((BusinessFlow)new DeleteDatabaseEntityCacheFlow()).putTemporaryData("tableName", (Object)tableName).putTemporaryData("oldTableColumn", (Object)oldTableColumn).putTemporaryData("newTableColumn", (Object)newTableColumn).execute();
    }

    @Override
    public void alterColumn(String tableName, PropertyOption propertyOption) {
        this.quickFlow.startFlow((BusinessFlow)new AlterTableColumnFlow()).next((BusinessFlow)new DeleteDatabaseEntityCacheFlow()).putTemporaryData("tableName", (Object)tableName).putTemporaryData("propertyOption", (Object)propertyOption).execute();
    }

    @Override
    public Property dropColumn(String tableName, String columnName) {
        FlowContext flowContext = this.quickFlow.startFlow((BusinessFlow)new DropTableColumnFlow()).next((BusinessFlow)new DeleteDatabaseEntityCacheFlow()).putTemporaryData("tableName", (Object)tableName).putTemporaryData("columnName", (Object)columnName).execute();
        Property property = (Property)flowContext.checkData("property");
        return property;
    }

    @Override
    public boolean hasIndex(String tableName, String indexName) {
        FlowContext flowContext = this.quickFlow.startFlow("\u5224\u65ad\u7d22\u5f15\u662f\u5426\u5b58\u5728").ignoreBroken(false).next((BusinessFlow)new HasTableFlow()).next((BusinessFlow)new HasIndexFlow()).putTemporaryData("tableName", (Object)tableName).putTemporaryData("indexName", (Object)indexName).execute();
        boolean hasResult = (Boolean)flowContext.checkData("hasResult");
        return hasResult;
    }

    @Override
    public boolean hasConstraint(String tableName, String constraintName) {
        FlowContext flowContext = this.quickFlow.startFlow((BusinessFlow)new HasConstraintFlow()).putTemporaryData("tableName", (Object)tableName).putTemporaryData("constraintName", (Object)constraintName).execute();
        boolean hasResult = (Boolean)flowContext.checkData("hasResult");
        return hasResult;
    }

    @Override
    public List<IndexField> getIndexFieldList(String tableName) {
        Entity entity = new Entity();
        entity.tableName = tableName;
        this.quickFlow.startFlow((BusinessFlow)new GetEntityIndexFlow()).putTemporaryData("entity", (Object)entity).execute();
        for (IndexField indexField : entity.indexFieldList) {
            indexField.tableName = tableName;
        }
        return entity.indexFieldList;
    }

    @Override
    public IndexField getIndexField(String tableName, String indexName) {
        FlowContext flowContext = this.quickFlow.startFlow((BusinessFlow)new GetSingleEntityIndexFlow()).putTemporaryData("tableName", (Object)tableName).putTemporaryData("indexName", (Object)indexName).execute();
        return (IndexField)flowContext.getData("indexField");
    }

    @Override
    public void createIndex(IndexField indexField) {
        this.quickFlow.startFlow((BusinessFlow)new CreateIndexFlow()).next((BusinessFlow)new DeleteDatabaseEntityCacheFlow()).putTemporaryData("indexField", (Object)indexField).putTemporaryData("tableName", (Object)indexField.tableName).execute();
    }

    @Override
    public void dropIndex(String tableName, String indexName) {
        this.quickFlow.startFlow((BusinessFlow)new DropIndexFlow()).next((BusinessFlow)new DeleteDatabaseEntityCacheFlow()).putTemporaryData("tableName", (Object)tableName).putTemporaryData("indexName", (Object)indexName).execute();
    }

    @Override
    public void createForeignKey(String tableName, PropertyOption propertyOption) {
        this.quickFlow.startFlow((BusinessFlow)new CreateForeignKeyFlow()).next((BusinessFlow)new DeleteDatabaseEntityCacheFlow()).putTemporaryData("tableName", (Object)tableName).putTemporaryData("propertyOption", (Object)propertyOption).execute();
    }

    @Override
    public void enableForeignConstraintCheck(boolean enable) {
        this.quickFlow.startFlow((BusinessFlow)new EnableForeignConstraintCheckFlow()).putTemporaryData("enable", (Object)enable).execute();
    }

    @Override
    public void backupTable(String tableName, String backupTableName) {
        this.quickFlow.startFlow((BusinessFlow)new BackupTableFlow()).putTemporaryData("tableName", (Object)tableName).putTemporaryData("backupTableName", (Object)backupTableName).execute();
    }

    @Override
    public void deleteDatabaseEntityCache(String ... tableNames) {
        if (null == tableNames || tableNames.length == 0) {
            this.quickDAOConfig.databaseContext.databaseTableCache.clear();
        } else {
            for (String tableName : tableNames) {
                this.quickDAOConfig.databaseContext.databaseTableCache.remove(tableName);
            }
        }
    }
}

