/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.domain.external;

import cn.schoolwow.quickdao.dao.DAO;
import cn.schoolwow.quickdao.dao.transaction.Transaction;
import cn.schoolwow.quickdao.domain.external.Entity;
import cn.schoolwow.quickdao.domain.internal.config.DatabaseContext;
import cn.schoolwow.quickdao.domain.internal.config.DatabaseOption;
import cn.schoolwow.quickdao.domain.internal.config.EntityOption;
import cn.schoolwow.quickdao.domain.internal.config.LogRecordOption;
import cn.schoolwow.quickdao.domain.internal.config.UpgradeOption;
import cn.schoolwow.quickdao.flow.ddl.index.GetEntityIndexFlow;
import cn.schoolwow.quickdao.flow.ddl.property.GetEntityPropertyFlow;
import cn.schoolwow.quickdao.flow.ddl.table.GetEntityFlow;
import cn.schoolwow.quickflow.QuickFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuickDAOConfig {
    private Logger logger = LoggerFactory.getLogger(QuickDAOConfig.class);
    public EntityOption entityOption = new EntityOption();
    public DatabaseOption databaseOption = new DatabaseOption();
    public DatabaseContext databaseContext = new DatabaseContext();
    public LogRecordOption logRecordOption = new LogRecordOption();
    public UpgradeOption upgradeOption = new UpgradeOption();
    public ThreadLocal<Transaction> transactionThreadLocal = new ThreadLocal();
    public ThreadPoolExecutor asyncThreadPool = (ThreadPoolExecutor)Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
    public QuickFlow quickFlow;
    public DAO dao;

    public Entity getEntityByClassName(String className) {
        if (this.databaseContext.entityMap.containsKey(className)) {
            return this.databaseContext.entityMap.get(className);
        }
        throw new IllegalArgumentException("\u626b\u63cf\u5b9e\u4f53\u7c7b\u5217\u8868\u4e2d\u4e0d\u5305\u542b\u8be5\u5b9e\u4f53\u7c7b!\u7c7b\u540d:" + className);
    }

    public Entity getDatabaseEntityByTableName(String tableName) {
        if (!this.databaseContext.databaseTableCache.containsKey(tableName)) {
            FlowContext flowContext = this.quickFlow.startFlow("\u83b7\u53d6\u6570\u636e\u5e93\u6307\u5b9a\u8868\u4fe1\u606f").putTemporaryData("tableName", (Object)tableName).putTemporaryData("insertSqlLog", (Object)false).next((BusinessFlow)new GetEntityFlow()).next((BusinessFlow)new GetEntityPropertyFlow()).next((BusinessFlow)new GetEntityIndexFlow()).execute();
            Entity entity = (Entity)flowContext.getData("entity");
            if (null == entity) {
                return null;
            }
            this.databaseContext.databaseTableCache.put(tableName, entity);
        }
        return this.databaseContext.databaseTableCache.get(tableName);
    }

    public void deleteDatabaseEntityCache(String tableName) {
        Iterator<Map.Entry<String, String>> entryIterator = this.databaseContext.statementCache.entrySet().iterator();
        while (entryIterator.hasNext()) {
            Map.Entry<String, String> entry = entryIterator.next();
            if (!entry.getKey().contains("_" + tableName + "_")) continue;
            this.logger.trace("\u5220\u9664SQL\u8bed\u53e5\u7f13\u5b58:{}", (Object)entry.getKey());
            entryIterator.remove();
        }
        this.logger.trace("\u5220\u9664\u6570\u636e\u5e93\u8868\u7f13\u5b58,\u8868\u540d:{}", (Object)tableName);
        this.databaseContext.databaseTableCache.remove(tableName);
    }
}

