/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.flow.ddl.createTable;

import cn.schoolwow.quickdao.annotation.IdStrategy;
import cn.schoolwow.quickdao.domain.external.Entity;
import cn.schoolwow.quickdao.domain.external.IndexField;
import cn.schoolwow.quickdao.domain.external.Property;
import cn.schoolwow.quickdao.domain.external.QuickDAOConfig;
import cn.schoolwow.quickdao.flow.ddl.common.GetAutoIncrementStatementFlow;
import cn.schoolwow.quickdao.flow.ddl.createTable.common.BuildForeignKeyFlow;
import cn.schoolwow.quickdao.flow.ddl.createTable.common.CheckOpenForeignKeyFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

public class PostgresCreateTableFlow
implements BusinessFlow {
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        flowContext.executeFlowList(new BusinessFlow[]{new CheckOpenForeignKeyFlow()});
        this.buildColumn(flowContext);
        flowContext.executeFlowList(new BusinessFlow[]{new BuildForeignKeyFlow()});
        this.buildTableComment(flowContext);
        this.buildIndex(flowContext);
        this.buildComment(flowContext);
    }

    public String name() {
        return "Postgres\u6570\u636e\u5e93\u521b\u5efa\u8868";
    }

    private void buildColumn(FlowContext flowContext) {
        StringBuilder sqlBuilder = (StringBuilder)flowContext.checkData("sqlBuilder");
        Entity entity = (Entity)flowContext.checkData("entity");
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig)flowContext.checkData("quickDAOConfig");
        sqlBuilder.append("create table " + quickDAOConfig.databaseContext.databaseProvider.escape(entity.tableName) + "(");
        for (Property property : entity.properties) {
            if (property.id && property.strategy == IdStrategy.AutoIncrement) {
                flowContext.startFlow((BusinessFlow)new GetAutoIncrementStatementFlow()).putTemporaryData("propertyOption", (Object)property).execute();
            } else {
                sqlBuilder.append(quickDAOConfig.databaseContext.databaseProvider.escape(property.column) + " " + property.columnType + (null == property.range ? "" : "(" + property.range + ")"));
                if (null != property.defaultValue && !property.defaultValue.isEmpty()) {
                    sqlBuilder.append(" default '" + property.defaultValue + "'");
                }
                if (null != property.notNull && property.notNull.booleanValue()) {
                    sqlBuilder.append(" not null");
                }
                if (null != property.comment) {
                    sqlBuilder.append(" " + quickDAOConfig.databaseContext.databaseProvider.comment(property.comment));
                }
                if (null != property.escapeCheck && !property.escapeCheck.isEmpty()) {
                    sqlBuilder.append(" check " + property.escapeCheck);
                }
            }
            sqlBuilder.append(",");
        }
    }

    private void buildIndex(FlowContext flowContext) {
        StringBuilder sqlBuilder = (StringBuilder)flowContext.checkData("sqlBuilder");
        Entity entity = (Entity)flowContext.checkData("entity");
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig)flowContext.checkData("quickDAOConfig");
        for (IndexField indexField : entity.indexFieldList) {
            sqlBuilder.append("create");
            switch (indexField.indexType) {
                case NORMAL: {
                    break;
                }
                case UNIQUE: {
                    sqlBuilder.append(" unique");
                    break;
                }
                case FULLTEXT: {
                    sqlBuilder.append(" fulltext");
                }
            }
            sqlBuilder.append(" index " + quickDAOConfig.databaseContext.databaseProvider.escape(indexField.indexName) + " on " + quickDAOConfig.databaseContext.databaseProvider.escape(indexField.tableName));
            if (null != indexField.using && !indexField.using.isEmpty()) {
                sqlBuilder.append(" using " + indexField.using);
            }
            sqlBuilder.append("(");
            for (String column : indexField.columns) {
                sqlBuilder.append(quickDAOConfig.databaseContext.databaseProvider.escape(column) + ",");
            }
            sqlBuilder.deleteCharAt(sqlBuilder.length() - 1);
            sqlBuilder.append(")");
            if (null != indexField.comment && !indexField.comment.isEmpty()) {
                sqlBuilder.append(" " + quickDAOConfig.databaseContext.databaseProvider.comment(indexField.comment));
            }
            sqlBuilder.append(";");
        }
    }

    private void buildTableComment(FlowContext flowContext) {
        StringBuilder sqlBuilder = (StringBuilder)flowContext.checkData("sqlBuilder");
        Entity entity = (Entity)flowContext.checkData("entity");
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig)flowContext.checkData("quickDAOConfig");
        if (null != entity.comment) {
            sqlBuilder.append(" " + quickDAOConfig.databaseContext.databaseProvider.comment(entity.comment));
        }
        sqlBuilder.append(");");
    }

    private void buildComment(FlowContext flowContext) {
        StringBuilder sqlBuilder = (StringBuilder)flowContext.checkData("sqlBuilder");
        Entity entity = (Entity)flowContext.checkData("entity");
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig)flowContext.checkData("quickDAOConfig");
        if (null != entity.comment) {
            sqlBuilder.append("comment on table " + quickDAOConfig.databaseContext.databaseProvider.escape(entity.tableName) + " is '" + entity.comment + "';");
        }
        for (Property property : entity.properties) {
            if (property.comment == null) continue;
            sqlBuilder.append("comment on column " + quickDAOConfig.databaseContext.databaseProvider.escape(entity.tableName) + "." + quickDAOConfig.databaseContext.databaseProvider.escape(property.column) + " is '" + property.comment + "';");
        }
    }
}

