/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.flow.ddl.has;

import cn.schoolwow.quickdao.domain.internal.DatabaseType;
import cn.schoolwow.quickdao.flow.ddl.has.common.SetHasResultSetFlow;
import cn.schoolwow.quickdao.flow.executor.ExecuteQueryConnectionFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import java.util.Arrays;

public class HasTableFlow
implements BusinessFlow {
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        DatabaseType databaseType = (DatabaseType)((Object)flowContext.checkData("databaseType"));
        String tableName = (String)flowContext.checkData("tableName");
        flowContext.putTemporaryData("name", (Object)"\u5224\u65ad\u8868\u662f\u5426\u5b58\u5728");
        switch (databaseType) {
            case H2: {
                tableName = tableName.toUpperCase();
                flowContext.putTemporaryData("sql", (Object)"select table_name from information_schema.tables where table_name = ?;");
                break;
            }
            case SQLite: {
                flowContext.putTemporaryData("sql", (Object)"select name from sqlite_master where type = 'table' and name = ?;");
                break;
            }
            case Mysql: 
            case MariaDB: {
                flowContext.putTemporaryData("sql", (Object)"show tables like ?;");
                break;
            }
            case Postgresql: {
                flowContext.putTemporaryData("sql", (Object)"select tablename from pg_tables where schemaname = 'public' and tablename = ?;");
                break;
            }
            case SQLServer: {
                flowContext.putTemporaryData("sql", (Object)"select name from sysobjects where xtype='u' and name = ?;");
                break;
            }
            case Oracle: {
                flowContext.putTemporaryData("sql", (Object)"select table_name from user_tables where table_name = ?");
            }
        }
        flowContext.putTemporaryData("parameters", Arrays.asList(tableName));
        flowContext.executeFlowList(new BusinessFlow[]{new SetHasResultSetFlow(), new ExecuteQueryConnectionFlow()});
        boolean hasResult = (Boolean)flowContext.checkData("hasResult");
        if (!hasResult) {
            flowContext.broken("\u8868\u4e0d\u5b58\u5728!\u8868\u540d:" + tableName);
        }
        flowContext.putReturnData("hasResult", (Object)hasResult);
    }

    public String name() {
        return "\u8868\u662f\u5426\u5b58\u5728";
    }
}

