/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.flow.ddl.index;

import cn.schoolwow.quickdao.domain.external.IndexField;
import cn.schoolwow.quickdao.domain.external.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.internal.DatabaseType;
import cn.schoolwow.quickdao.domain.internal.common.ResultSetConsumer;
import cn.schoolwow.quickdao.flow.executor.ExecuteQueryConnectionFlow;
import cn.schoolwow.quickdao.flow.executor.ExecuteUpdateConnectionFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CreateIndexFlow
implements BusinessFlow {
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        this.setIndexName(flowContext);
        this.checkPostgres(flowContext);
        this.setIndexColumnNameStatement(flowContext);
        this.setStatement(flowContext);
        this.executeStatement(flowContext);
    }

    public String name() {
        return "\u521b\u5efa\u7d22\u5f15";
    }

    private void setIndexName(FlowContext flowContext) {
        IndexField indexField = (IndexField)flowContext.checkData("indexField");
        if (null == indexField.indexName || indexField.indexName.isEmpty()) {
            StringBuilder indexNameBuilder = new StringBuilder(indexField.tableName + "_" + indexField.indexType.name().toLowerCase() + "_");
            for (String column : indexField.columns) {
                indexNameBuilder.append(column + ",");
            }
            indexNameBuilder.deleteCharAt(indexNameBuilder.length() - 1);
            indexField.indexName = indexNameBuilder.toString();
        }
    }

    private void checkPostgres(final FlowContext flowContext) {
        IndexField indexField = (IndexField)flowContext.checkData("indexField");
        DatabaseType databaseType = (DatabaseType)((Object)flowContext.checkData("databaseType"));
        switch (databaseType) {
            case Postgresql: {
                flowContext.startFlow((BusinessFlow)new ExecuteQueryConnectionFlow()).putTemporaryData("name", (Object)"\u67e5\u8be2\u6570\u636e\u5e93\u7d22\u5f15\u662f\u5426\u5df2\u5b58\u5728").putTemporaryData("sql", (Object)"select tablename,indexname,indexdef from pg_indexes where indexname = ?;").putTemporaryData("parameters", Arrays.asList(indexField.indexName)).putReturnData("resultSetConsumer", (Object)new ResultSetConsumer(){

                    @Override
                    public void consumeResultSet(ResultSet resultSet) throws Exception {
                        ArrayList<String> existIndexTableNameList = new ArrayList<String>();
                        while (resultSet.next()) {
                            existIndexTableNameList.add(resultSet.getString("tablename"));
                        }
                        flowContext.putTemporaryData("existIndexTableNameList", existIndexTableNameList);
                    }
                }).execute();
            }
        }
        List existIndexTableNameList = (List)flowContext.getData("existIndexTableNameList");
        if (null != existIndexTableNameList && !existIndexTableNameList.isEmpty()) {
            throw new IllegalArgumentException("Postgres\u6570\u636e\u5e93\u7d22\u5f15\u540d\u5fc5\u987b\u5168\u5c40\u552f\u4e00!\u7d22\u5f15\u540d:" + indexField.indexName + ",\u5df2\u5b58\u5728\u8be5\u7d22\u5f15\u7684\u8868\u540d:" + existIndexTableNameList);
        }
    }

    private void setIndexColumnNameStatement(FlowContext flowContext) {
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig)flowContext.checkData("quickDAOConfig");
        IndexField indexField = (IndexField)flowContext.checkData("indexField");
        StringBuilder indexColumnNameStatementBuilder = new StringBuilder();
        indexColumnNameStatementBuilder.append("(");
        for (String column : indexField.columns) {
            indexColumnNameStatementBuilder.append(quickDAOConfig.databaseContext.databaseProvider.escape(column) + ",");
        }
        indexColumnNameStatementBuilder.deleteCharAt(indexColumnNameStatementBuilder.length() - 1);
        indexColumnNameStatementBuilder.append(")");
        flowContext.putCurrentFlowData("indexColumnNameStatement", (Object)indexColumnNameStatementBuilder.toString());
    }

    private void setStatement(FlowContext flowContext) {
        DatabaseType databaseType = (DatabaseType)((Object)flowContext.checkData("databaseType"));
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig)flowContext.checkData("quickDAOConfig");
        IndexField indexField = (IndexField)flowContext.checkData("indexField");
        String indexColumnNameStatement = (String)flowContext.checkData("indexColumnNameStatement");
        StringBuilder sqlBuilder = new StringBuilder("create");
        switch (indexField.indexType) {
            case NORMAL: {
                break;
            }
            case UNIQUE: {
                sqlBuilder.append(" unique");
                break;
            }
            case FULLTEXT: {
                sqlBuilder.append(" fulltext");
            }
        }
        sqlBuilder.append(" index " + quickDAOConfig.databaseContext.databaseProvider.escape(indexField.indexName) + " on " + quickDAOConfig.databaseContext.databaseProvider.escape(indexField.tableName));
        switch (databaseType) {
            case Postgresql: {
                if (null != indexField.using && !indexField.using.isEmpty()) {
                    sqlBuilder.append(" using " + indexField.using);
                }
                sqlBuilder.append(indexColumnNameStatement);
                break;
            }
            case SQLite: {
                if (null != indexField.using && !indexField.using.isEmpty()) {
                    flowContext.remark("SQLite\u4e0d\u652f\u6301using\u8bed\u6cd5");
                }
            }
            default: {
                sqlBuilder.append(indexColumnNameStatement);
            }
        }
        if (null != indexField.comment && !indexField.comment.isEmpty()) {
            sqlBuilder.append(" " + quickDAOConfig.databaseContext.databaseProvider.comment(indexField.comment));
        }
        sqlBuilder.append(";");
        flowContext.putTemporaryData("sql", (Object)sqlBuilder.toString());
    }

    private void executeStatement(FlowContext flowContext) {
        flowContext.startFlow((BusinessFlow)new ExecuteUpdateConnectionFlow()).putTemporaryData("name", (Object)"\u521b\u5efa\u7d22\u5f15").execute();
    }
}

