/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.flow.ddl.index;

import cn.schoolwow.quickdao.annotation.IndexType;
import cn.schoolwow.quickdao.domain.external.IndexField;
import cn.schoolwow.quickdao.domain.external.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.internal.DatabaseType;
import cn.schoolwow.quickdao.domain.internal.common.ResultSetConsumer;
import cn.schoolwow.quickdao.flow.executor.ExecuteQueryConnectionFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;

public class GetSingleEntityIndexFlow
implements BusinessFlow {
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        DatabaseType databaseType = (DatabaseType)((Object)flowContext.checkData("databaseType"));
        flowContext.putTemporaryData("name", (Object)"\u83b7\u53d6\u6307\u5b9a\u8868\u6307\u5b9a\u7d22\u5f15\u4fe1\u606f");
        switch (databaseType) {
            case H2: {
                this.getByH2(flowContext);
                break;
            }
            case SQLite: {
                this.getBySQLite(flowContext);
                break;
            }
            case Mysql: 
            case MariaDB: {
                this.getByMysql(flowContext);
                break;
            }
            case Postgresql: {
                this.getByPostgres(flowContext);
                break;
            }
            case SQLServer: {
                this.getBySQLServer(flowContext);
                break;
            }
            case Oracle: {
                this.getByOracle(flowContext);
            }
        }
    }

    public String name() {
        return "\u83b7\u53d6\u6570\u636e\u5e93\u5b57\u6bb5\u4fe1\u606f";
    }

    private void getByH2(final FlowContext flowContext) {
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig)flowContext.checkData("quickDAOConfig");
        String tableName = (String)flowContext.checkData("tableName");
        final String indexName = (String)flowContext.checkData("indexName");
        flowContext.startFlow((BusinessFlow)new ExecuteQueryConnectionFlow()).putTemporaryData("sql", (Object)("select table_name, sql from information_schema.indexes where table_schema = '" + quickDAOConfig.databaseContext.databaseName + "' and table_name = ?")).putTemporaryData("parameters", Arrays.asList(tableName.toUpperCase())).putReturnData("resultSetConsumer", (Object)new ResultSetConsumer(){

            @Override
            public void consumeResultSet(ResultSet resultSet) throws Exception {
                while (resultSet.next()) {
                    String sql = resultSet.getString("sql");
                    String[] tokens = sql.split("\"");
                    IndexField indexField = new IndexField();
                    indexField.indexType = tokens[0].contains("UNIQUE") ? IndexType.UNIQUE : IndexType.NORMAL;
                    indexField.indexName = tokens[3];
                    indexField.tableName = tokens[7];
                    for (int i = 9; i < tokens.length - 1; ++i) {
                        indexField.columns.add(tokens[i]);
                    }
                    if (!indexField.indexName.equalsIgnoreCase(indexName)) continue;
                    flowContext.putData("indexField", (Object)indexField);
                    break;
                }
            }
        }).execute();
    }

    private void getBySQLite(final FlowContext flowContext) {
        String tableName = (String)flowContext.checkData("tableName");
        final String indexName = (String)flowContext.checkData("indexName");
        flowContext.startFlow((BusinessFlow)new ExecuteQueryConnectionFlow()).putTemporaryData("sql", (Object)"select tbl_name, sql from sqlite_master where type='index' and tbl_name = ? and sql is not null;").putTemporaryData("parameters", Arrays.asList(tableName)).putReturnData("resultSetConsumer", (Object)new ResultSetConsumer(){

            @Override
            public void consumeResultSet(ResultSet resultSet) throws Exception {
                ArrayList<String> warningSQLList = new ArrayList<String>();
                while (resultSet.next()) {
                    String sql = resultSet.getString("sql");
                    if (!sql.contains("\"") && !sql.contains("`")) {
                        warningSQLList.add(sql);
                        continue;
                    }
                    String[] tokens = sql.split("[\"|`]");
                    IndexField indexField = new IndexField();
                    indexField.indexType = tokens[0].contains("UNIQUE") ? IndexType.UNIQUE : IndexType.NORMAL;
                    indexField.indexName = tokens[1];
                    indexField.tableName = tokens[3];
                    for (int i = 5; i < tokens.length - 1; ++i) {
                        indexField.columns.add(tokens[i]);
                    }
                    if (!indexField.indexName.equalsIgnoreCase(indexName)) continue;
                    flowContext.putData("indexField", (Object)indexField);
                    break;
                }
                if (!warningSQLList.isEmpty()) {
                    flowContext.putTemporaryData("warningSQLList", warningSQLList);
                    flowContext.remark("\u5b58\u5728\u5f02\u5e38\u7d22\u5f15!\u7d22\u5f15\u4e0d\u5305\u542b\"\u4e5f\u4e0d\u5305\u542b`");
                }
            }
        }).execute();
    }

    private void getByMysql(final FlowContext flowContext) {
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig)flowContext.checkData("quickDAOConfig");
        String tableName = (String)flowContext.checkData("tableName");
        String indexName = (String)flowContext.checkData("indexName");
        flowContext.startFlow((BusinessFlow)new ExecuteQueryConnectionFlow()).putTemporaryData("sql", (Object)("select table_name, index_name, non_unique, column_name, index_type, index_comment from information_schema.`statistics` where table_schema = '" + quickDAOConfig.databaseContext.databaseName + "' and table_name = ? and index_name = ?;")).putTemporaryData("parameters", Arrays.asList(tableName, indexName)).putReturnData("resultSetConsumer", (Object)new ResultSetConsumer(){

            @Override
            public void consumeResultSet(ResultSet resultSet) throws Exception {
                IndexField indexField = null;
                while (resultSet.next()) {
                    if (null == indexField) {
                        indexField = new IndexField();
                        IndexType indexType = indexField.indexType = resultSet.getInt("non_unique") == 0 ? IndexType.UNIQUE : IndexType.NORMAL;
                        if ("FULLTEXT".equals(resultSet.getString("index_type"))) {
                            indexField.indexType = IndexType.FULLTEXT;
                        }
                        indexField.indexName = resultSet.getString("index_name");
                        indexField.columns.add(resultSet.getString("column_name"));
                        indexField.using = resultSet.getString("index_type");
                        indexField.comment = resultSet.getString("index_comment");
                        continue;
                    }
                    indexField.columns.add(resultSet.getString("column_name"));
                }
                flowContext.putData("indexField", indexField);
            }
        }).execute();
    }

    private void getByPostgres(final FlowContext flowContext) {
        String tableName = (String)flowContext.checkData("tableName");
        String indexName = (String)flowContext.checkData("indexName");
        flowContext.startFlow((BusinessFlow)new ExecuteQueryConnectionFlow()).putTemporaryData("sql", (Object)"select tablename,indexname,indexdef from pg_indexes where tablename = ? and indexname = ?;").putTemporaryData("parameters", Arrays.asList(tableName, indexName)).putReturnData("resultSetConsumer", (Object)new ResultSetConsumer(){

            @Override
            public void consumeResultSet(ResultSet resultSet) throws Exception {
                if (resultSet.next()) {
                    IndexField indexField = new IndexField();
                    indexField.tableName = resultSet.getString("tablename");
                    indexField.indexName = resultSet.getString("indexname");
                    String def = resultSet.getString("indexdef");
                    indexField.indexType = def.contains("UNIQUE INDEX") ? IndexType.UNIQUE : IndexType.NORMAL;
                    indexField.using = def.substring(def.indexOf("USING") + "USING".length(), def.indexOf("(")).replace("\"", "").trim();
                    String[] columns = def.substring(def.indexOf("(") + 1, def.indexOf(")")).split(",");
                    for (int i = 0; i < columns.length; ++i) {
                        indexField.columns.add(columns[i].trim());
                    }
                    flowContext.putData("indexField", (Object)indexField);
                }
            }
        }).execute();
    }

    private void getBySQLServer(final FlowContext flowContext) {
        String tableName = (String)flowContext.checkData("tableName");
        String indexName = (String)flowContext.checkData("indexName");
        flowContext.startFlow((BusinessFlow)new ExecuteQueryConnectionFlow()).putTemporaryData("sql", (Object)"select i.is_unique,i.name,col.name col_name from sys.indexes i left join sys.index_columns ic on ic.object_id = i.object_id and ic.index_id = i.index_id left join (select * from sys.all_columns where object_id = object_id(?, N'U' )) col on ic.column_id = col.column_id where i.object_id = object_id(?, N'U' ) and i.index_id > 0 and i.name = ?;").putTemporaryData("parameters", Arrays.asList(tableName, tableName, indexName)).putReturnData("resultSetConsumer", (Object)new ResultSetConsumer(){

            @Override
            public void consumeResultSet(ResultSet resultSet) throws Exception {
                IndexField indexField = null;
                while (resultSet.next()) {
                    if (null == indexField) {
                        indexField = new IndexField();
                        indexField.indexType = resultSet.getBoolean("is_unique") ? IndexType.UNIQUE : IndexType.NORMAL;
                        indexField.indexName = resultSet.getString("name");
                        indexField.columns.add(resultSet.getNString("col_name"));
                        continue;
                    }
                    indexField.columns.add(resultSet.getNString("col_name"));
                }
                flowContext.putData("indexField", indexField);
            }
        }).execute();
    }

    private void getByOracle(final FlowContext flowContext) {
        String tableName = (String)flowContext.checkData("tableName");
        String indexName = (String)flowContext.checkData("indexName");
        flowContext.startFlow((BusinessFlow)new ExecuteQueryConnectionFlow()).putTemporaryData("sql", (Object)"select table_name, index_name,uniqueness from user_indexes where table_name = ? and index_name = ?").putTemporaryData("parameters", Arrays.asList(tableName, indexName)).putReturnData("resultSetConsumer", (Object)new ResultSetConsumer(){

            @Override
            public void consumeResultSet(ResultSet resultSet) throws Exception {
                if (resultSet.next()) {
                    IndexField indexField = new IndexField();
                    indexField.tableName = resultSet.getString("table_name");
                    indexField.indexType = "UNIQUE".equalsIgnoreCase(resultSet.getString("uniqueness")) ? IndexType.UNIQUE : IndexType.NORMAL;
                    indexField.indexName = resultSet.getString("index_name");
                    flowContext.putData("indexField", (Object)indexField);
                }
            }
        }).execute();
        final IndexField indexField = (IndexField)flowContext.getData("indexField");
        if (null == indexField) {
            return;
        }
        flowContext.startFlow((BusinessFlow)new ExecuteQueryConnectionFlow()).putTemporaryData("name", (Object)"\u83b7\u53d6\u7d22\u5f15\u5b57\u6bb5\u4fe1\u606f").putTemporaryData("sql", (Object)"select table_name,index_name,column_name from user_ind_columns where table_name = ? and index_name = ?").putTemporaryData("parameters", Arrays.asList(tableName, indexName)).putReturnData("resultSetConsumer", (Object)new ResultSetConsumer(){

            @Override
            public void consumeResultSet(ResultSet resultSet) throws Exception {
                while (resultSet.next()) {
                    String columnName = resultSet.getString("column_name");
                    indexField.columns.add(columnName);
                }
            }
        }).execute();
    }
}

