/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.flow.ddl.property;

import cn.schoolwow.quickdao.annotation.IdStrategy;
import cn.schoolwow.quickdao.domain.external.PropertyOption;
import cn.schoolwow.quickdao.domain.external.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.internal.DatabaseType;
import cn.schoolwow.quickdao.flow.ddl.common.GetAutoIncrementStatementFlow;
import cn.schoolwow.quickdao.flow.ddl.common.GetEscapeCheckFlow;
import cn.schoolwow.quickdao.flow.executor.ExecuteUpdateConnectionFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

public class AlterTableColumnFlow
implements BusinessFlow {
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        this.checkCanAlterTableColumn(flowContext);
        flowContext.executeFlowList(new BusinessFlow[]{new GetEscapeCheckFlow()});
        this.setStatement(flowContext);
        this.executeStatement(flowContext);
    }

    public String name() {
        return "\u4fee\u6539\u8868\u5b57\u6bb5";
    }

    private void checkCanAlterTableColumn(FlowContext flowContext) {
        DatabaseType databaseType = (DatabaseType)((Object)flowContext.checkData("databaseType"));
        switch (databaseType) {
            case SQLite: {
                throw new IllegalArgumentException("SQLite\u6570\u636e\u5e93\u4e0d\u652f\u6301\u4fee\u6539\u5b57\u6bb5");
            }
        }
    }

    private void setStatement(FlowContext flowContext) {
        DatabaseType databaseType = (DatabaseType)((Object)flowContext.checkData("databaseType"));
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig)flowContext.checkData("quickDAOConfig");
        String tableName = (String)flowContext.checkData("tableName");
        PropertyOption propertyOption = (PropertyOption)flowContext.checkData("propertyOption");
        String escapeCheck = (String)flowContext.getData("escapeCheck");
        StringBuilder sqlBuilder = new StringBuilder("alter table " + quickDAOConfig.databaseContext.databaseProvider.escape(tableName));
        switch (databaseType) {
            case SQLServer: 
            case Postgresql: {
                sqlBuilder.append(" alter");
                break;
            }
            default: {
                sqlBuilder.append(" modify");
            }
        }
        sqlBuilder.append(" column " + quickDAOConfig.databaseContext.databaseProvider.escape(propertyOption.column));
        switch (databaseType) {
            case Postgresql: {
                sqlBuilder.append(" type");
            }
        }
        sqlBuilder.append(" " + propertyOption.columnType);
        if (!propertyOption.columnType.contains("(")) {
            sqlBuilder.append(null == propertyOption.range ? "" : "(" + propertyOption.range + ")");
        }
        if (propertyOption.id && propertyOption.strategy.equals((Object)IdStrategy.AutoIncrement)) {
            flowContext.startFlow((BusinessFlow)new GetAutoIncrementStatementFlow()).putTemporaryData("sqlBuilder", (Object)sqlBuilder).execute();
        }
        if (null != propertyOption.notNull && propertyOption.notNull.booleanValue()) {
            sqlBuilder.append(" not null");
        }
        if (null != propertyOption.defaultValue && !propertyOption.defaultValue.isEmpty()) {
            sqlBuilder.append(" default " + propertyOption.defaultValue);
        }
        if (null != escapeCheck && !escapeCheck.isEmpty()) {
            sqlBuilder.append(" check " + escapeCheck);
        }
        if (null != propertyOption.comment) {
            sqlBuilder.append(" " + quickDAOConfig.databaseContext.databaseProvider.comment(propertyOption.comment));
        }
        sqlBuilder.append(";");
        flowContext.putTemporaryData("sql", (Object)sqlBuilder.toString());
    }

    private void executeStatement(FlowContext flowContext) {
        flowContext.startFlow((BusinessFlow)new ExecuteUpdateConnectionFlow()).putTemporaryData("name", (Object)"\u4fee\u6539\u5217").execute();
    }
}

