/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.flow.ddl.property;

import cn.schoolwow.quickdao.domain.external.QuickDAOConfig;
import cn.schoolwow.quickdao.flow.executor.ExecuteUpdateConnectionFlow;
import cn.schoolwow.quickdao.util.StringUtil;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

public class RenameTableColumnFlow
implements BusinessFlow {
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig)flowContext.checkData("quickDAOConfig");
        String tableName = (String)flowContext.checkData("tableName");
        String oldTableColumn = (String)flowContext.checkData("oldTableColumn");
        String newTableColumn = (String)flowContext.checkData("newTableColumn");
        tableName = StringUtil.camel2Underline(tableName);
        oldTableColumn = StringUtil.camel2Underline(oldTableColumn);
        newTableColumn = StringUtil.camel2Underline(newTableColumn);
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("alter table " + quickDAOConfig.databaseContext.databaseProvider.escape(tableName));
        sqlBuilder.append(" rename column " + quickDAOConfig.databaseContext.databaseProvider.escape(oldTableColumn));
        sqlBuilder.append(" to " + quickDAOConfig.databaseContext.databaseProvider.escape(newTableColumn) + ";");
        flowContext.startFlow((BusinessFlow)new ExecuteUpdateConnectionFlow()).putTemporaryData("name", (Object)"\u91cd\u547d\u540d\u5217").putTemporaryData("sql", (Object)sqlBuilder.toString()).execute();
    }

    public String name() {
        return "\u91cd\u547d\u540d\u5217";
    }
}

