/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.flow.ddl.table;

import cn.schoolwow.quickdao.domain.external.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.internal.DatabaseType;
import cn.schoolwow.quickdao.flow.executor.ExecuteUpdateConnectionFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

public class BackupTableFlow
implements BusinessFlow {
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig)flowContext.checkData("quickDAOConfig");
        DatabaseType databaseType = (DatabaseType)((Object)flowContext.checkData("databaseType"));
        String tableName = (String)flowContext.checkData("tableName");
        String backupTableName = (String)flowContext.checkData("backupTableName");
        switch (databaseType) {
            case Mysql: 
            case MariaDB: {
                flowContext.putTemporaryData("sql", (Object)("create table " + quickDAOConfig.databaseContext.databaseProvider.escape(backupTableName) + " as select * from " + quickDAOConfig.databaseContext.databaseProvider.escape(tableName) + ";"));
                break;
            }
            case Postgresql: {
                flowContext.putTemporaryData("sql", (Object)("select * into " + quickDAOConfig.databaseContext.databaseProvider.escape(backupTableName) + " from " + quickDAOConfig.databaseContext.databaseProvider.escape(tableName) + ";"));
                break;
            }
            default: {
                throw new UnsupportedOperationException("\u5f53\u524d\u4e0d\u652f\u6301" + databaseType.name() + "\u6570\u636e\u5e93\u5907\u4efd\u8868\u529f\u80fd");
            }
        }
        flowContext.startFlow((BusinessFlow)new ExecuteUpdateConnectionFlow()).putTemporaryData("name", (Object)"\u5907\u4efd\u8868").execute();
    }

    public String name() {
        return "\u5907\u4efd\u8868";
    }
}

