/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.flow.ddl.table;

import cn.schoolwow.quickdao.domain.external.Entity;
import cn.schoolwow.quickdao.domain.internal.DatabaseType;
import cn.schoolwow.quickdao.domain.internal.common.ResultSetConsumer;
import cn.schoolwow.quickdao.flow.ddl.table.GetEntityListFlow;
import cn.schoolwow.quickdao.flow.executor.ExecuteQueryConnectionFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;

public class GetEntityFlow
implements BusinessFlow {
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        DatabaseType databaseType = (DatabaseType)((Object)flowContext.checkData("databaseType"));
        switch (databaseType) {
            case H2: {
                this.getByH2(flowContext);
                break;
            }
            case SQLite: {
                this.getBySQLite(flowContext);
                break;
            }
            case Mysql: 
            case MariaDB: {
                this.getByMysql(flowContext);
                break;
            }
            case Postgresql: {
                this.getByPostgres(flowContext);
                break;
            }
            case SQLServer: {
                this.getBySQLServer(flowContext);
                break;
            }
            case Oracle: {
                this.getByOracle(flowContext);
            }
        }
        String tableName = (String)flowContext.checkData("tableName");
        if (null == flowContext.getData("entity")) {
            flowContext.broken("\u8868\u4e0d\u5b58\u5728!\u8868\u540d:" + tableName);
        }
    }

    public String name() {
        return "\u83b7\u53d6\u6570\u636e\u5e93\u6307\u5b9a\u8868\u4fe1\u606f";
    }

    private void getByH2(FlowContext flowContext) {
        String tableName = (String)flowContext.checkData("tableName");
        flowContext.executeFlowList(new BusinessFlow[]{new GetEntityListFlow()});
        List entityList = (List)flowContext.checkData("entityList");
        for (Entity entity : entityList) {
            if (!entity.tableName.equalsIgnoreCase(tableName)) continue;
            flowContext.putData("entity", (Object)entity);
            break;
        }
    }

    private void getBySQLite(final FlowContext flowContext) {
        String tableName = (String)flowContext.checkData("tableName");
        flowContext.startFlow((BusinessFlow)new ExecuteQueryConnectionFlow()).putTemporaryData("name", (Object)"\u83b7\u53d6\u6307\u5b9a\u8868\u4fe1\u606f").putTemporaryData("sql", (Object)"select name from sqlite_master where type = 'table' and name = ?;").putTemporaryData("parameters", Arrays.asList(tableName)).putReturnData("resultSetConsumer", (Object)new ResultSetConsumer(){

            @Override
            public void consumeResultSet(ResultSet resultSet) throws Exception {
                if (resultSet.next()) {
                    Entity entity = new Entity();
                    entity.tableName = resultSet.getString("name");
                    flowContext.putData("entity", (Object)entity);
                }
            }
        }).execute();
    }

    private void getByMysql(final FlowContext flowContext) {
        final String tableName = (String)flowContext.checkData("tableName");
        flowContext.startFlow((BusinessFlow)new ExecuteQueryConnectionFlow()).putTemporaryData("name", (Object)"\u83b7\u53d6\u6307\u5b9a\u8868\u4fe1\u606f").putTemporaryData("sql", (Object)"show table status;").putReturnData("resultSetConsumer", (Object)new ResultSetConsumer(){

            @Override
            public void consumeResultSet(ResultSet resultSet) throws Exception {
                while (resultSet.next()) {
                    if (!tableName.equalsIgnoreCase(resultSet.getString("name"))) continue;
                    Entity entity = new Entity();
                    entity.tableName = resultSet.getString("name");
                    entity.comment = resultSet.getString("comment").replace("\"", "\\\"");
                    flowContext.putData("entity", (Object)entity);
                    break;
                }
            }
        }).execute();
    }

    private void getByPostgres(final FlowContext flowContext) {
        String tableName = (String)flowContext.checkData("tableName");
        flowContext.startFlow((BusinessFlow)new ExecuteQueryConnectionFlow()).putTemporaryData("name", (Object)"\u83b7\u53d6\u6307\u5b9a\u8868\u4fe1\u606f").putTemporaryData("sql", (Object)"select relname as name,cast(obj_description(relfilenode,'pg_class') as varchar) as comment from pg_class c where relkind = 'r' and relname = ? order by relname;").putTemporaryData("parameters", Arrays.asList(tableName)).putReturnData("resultSetConsumer", (Object)new ResultSetConsumer(){

            @Override
            public void consumeResultSet(ResultSet resultSet) throws Exception {
                if (resultSet.next()) {
                    Entity entity = new Entity();
                    entity.tableName = resultSet.getString("name");
                    entity.comment = resultSet.getString("comment");
                    flowContext.putData("entity", (Object)entity);
                }
            }
        }).execute();
    }

    private void getBySQLServer(final FlowContext flowContext) {
        String tableName = (String)flowContext.checkData("tableName");
        flowContext.startFlow((BusinessFlow)new ExecuteQueryConnectionFlow()).putTemporaryData("name", (Object)"\u83b7\u53d6\u6307\u5b9a\u8868\u4fe1\u606f").putTemporaryData("sql", (Object)"select name from sysobjects where xtype='u' and name = ? order by name;").putTemporaryData("parameters", Arrays.asList(tableName)).putReturnData("resultSetConsumer", (Object)new ResultSetConsumer(){

            @Override
            public void consumeResultSet(ResultSet resultSet) throws Exception {
                if (resultSet.next()) {
                    Entity entity = new Entity();
                    entity.tableName = resultSet.getString("name");
                    flowContext.putData("entity", (Object)entity);
                }
            }
        }).execute();
        if (flowContext.containKey("entity")) {
            final Entity entity = (Entity)flowContext.checkData("entity");
            flowContext.startFlow((BusinessFlow)new ExecuteQueryConnectionFlow()).putTemporaryData("name", (Object)"\u83b7\u53d6\u6307\u5b9a\u8868\u6ce8\u91ca\u4fe1\u606f").putTemporaryData("sql", (Object)"select so.name table_name, isnull(convert(varchar(255),value),'') comment from sys.extended_properties ex_p left join sys.sysobjects so on ex_p.major_id = so.id where ex_p.minor_id=0 and so.name = ?;").putTemporaryData("parameters", Arrays.asList(tableName)).putReturnData("resultSetConsumer", (Object)new ResultSetConsumer(){

                @Override
                public void consumeResultSet(ResultSet resultSet) throws Exception {
                    if (resultSet.next()) {
                        entity.comment = resultSet.getString("comment");
                    }
                }
            }).execute();
        }
    }

    private void getByOracle(final FlowContext flowContext) throws SQLException {
        String tableName = (String)flowContext.checkData("tableName");
        flowContext.startFlow((BusinessFlow)new ExecuteQueryConnectionFlow()).putTemporaryData("name", (Object)"\u83b7\u53d6\u6307\u5b9a\u8868\u4fe1\u606f").putTemporaryData("sql", (Object)"select user_tables.table_name,user_tab_comments.comments from user_tables left join user_tab_comments on user_tables.table_name = user_tab_comments.table_name where user_tables.table_name = ?").putTemporaryData("parameters", Arrays.asList(tableName)).putReturnData("resultSetConsumer", (Object)new ResultSetConsumer(){

            @Override
            public void consumeResultSet(ResultSet resultSet) throws Exception {
                if (resultSet.next()) {
                    Entity entity = new Entity();
                    entity.tableName = resultSet.getString("table_name");
                    entity.comment = resultSet.getString("comments");
                    flowContext.putData("entity", (Object)entity);
                }
            }
        }).execute();
    }
}

