/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.flow.ddl.table;

import cn.schoolwow.quickdao.domain.internal.DatabaseType;
import cn.schoolwow.quickdao.domain.internal.common.ResultSetConsumer;
import cn.schoolwow.quickdao.flow.executor.ExecuteQueryConnectionFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import java.sql.ResultSet;
import java.util.ArrayList;

public class GetTableNameListFlow
implements BusinessFlow {
    public void executeBusinessFlow(final FlowContext flowContext) throws Exception {
        DatabaseType databaseType = (DatabaseType)((Object)flowContext.checkData("databaseType"));
        flowContext.putTemporaryData("name", (Object)"\u83b7\u53d6\u6570\u636e\u5e93\u8868\u540d\u5217\u8868");
        switch (databaseType) {
            case H2: {
                flowContext.putTemporaryData("sql", (Object)"show tables;");
                flowContext.putTemporaryData("tableNameColumn", (Object)"TABLE_NAME");
                break;
            }
            case SQLite: {
                flowContext.putTemporaryData("sql", (Object)"select name from sqlite_master where type='table' and name != 'sqlite_sequence';");
                flowContext.putTemporaryData("tableNameColumn", (Object)"name");
                break;
            }
            case Mysql: 
            case MariaDB: {
                flowContext.putTemporaryData("sql", (Object)"show table status;");
                flowContext.putTemporaryData("tableNameColumn", (Object)"name");
                break;
            }
            case Postgresql: {
                flowContext.putTemporaryData("sql", (Object)"select relname as name from pg_class c where relkind = 'r' and relname not like 'pg_%' and relname not like 'sql_%' order by relname;");
                flowContext.putTemporaryData("tableNameColumn", (Object)"name");
                break;
            }
            case SQLServer: {
                flowContext.putTemporaryData("sql", (Object)"select name from sysobjects where xtype='u' order by name;");
                flowContext.putTemporaryData("tableNameColumn", (Object)"name");
                break;
            }
            case Oracle: {
                flowContext.putTemporaryData("sql", (Object)"select user_tables.table_name from user_tables");
                flowContext.putTemporaryData("tableNameColumn", (Object)"table_name");
            }
        }
        flowContext.startFlow((BusinessFlow)new ExecuteQueryConnectionFlow()).putReturnData("resultSetConsumer", (Object)new ResultSetConsumer(){

            @Override
            public void consumeResultSet(ResultSet resultSet) throws Exception {
                ArrayList<String> tableNameList = new ArrayList<String>();
                String tableNameColumn = (String)flowContext.checkData("tableNameColumn");
                while (resultSet.next()) {
                    tableNameList.add(resultSet.getString(tableNameColumn));
                }
                flowContext.putData("tableNameList", tableNameList);
            }
        }).execute();
    }

    public String name() {
        return "\u83b7\u53d6\u6570\u636e\u5e93\u8868\u540d\u5217\u8868";
    }
}

