/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.flow.ddl.table;

import cn.schoolwow.quickdao.domain.external.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.internal.DatabaseType;
import cn.schoolwow.quickdao.flow.executor.ExecuteUpdateConnectionFlow;
import cn.schoolwow.quickdao.util.StringUtil;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

public class RenameTableFlow
implements BusinessFlow {
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        this.setRenameStatement(flowContext);
        this.executeStatement(flowContext);
    }

    public String name() {
        return "\u91cd\u547d\u540d\u8868";
    }

    private void setRenameStatement(FlowContext flowContext) {
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig)flowContext.checkData("quickDAOConfig");
        String oldTableName = (String)flowContext.checkData("oldTableName");
        String newTableName = (String)flowContext.checkData("newTableName");
        DatabaseType databaseType = (DatabaseType)((Object)flowContext.checkData("databaseType"));
        oldTableName = StringUtil.camel2Underline(oldTableName);
        newTableName = StringUtil.camel2Underline(newTableName);
        switch (databaseType) {
            case Postgresql: {
                flowContext.putTemporaryData("sql", (Object)("alter table " + quickDAOConfig.databaseContext.databaseProvider.escape(oldTableName) + " rename to " + quickDAOConfig.databaseContext.databaseProvider.escape(newTableName) + ";"));
                break;
            }
            default: {
                flowContext.putTemporaryData("sql", (Object)("rename table " + quickDAOConfig.databaseContext.databaseProvider.escape(oldTableName) + " to " + quickDAOConfig.databaseContext.databaseProvider.escape(newTableName) + ";"));
            }
        }
    }

    private void executeStatement(FlowContext flowContext) {
        flowContext.startFlow((BusinessFlow)new ExecuteUpdateConnectionFlow()).putTemporaryData("name", (Object)"\u91cd\u547d\u540d\u8868").execute();
    }
}

