/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.flow.dml.instance.common.filter;

import cn.schoolwow.quickdao.domain.external.Entity;
import cn.schoolwow.quickdao.domain.external.Property;
import cn.schoolwow.quickdao.domain.external.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.external.dml.CheckStrategy;
import cn.schoolwow.quickdao.domain.internal.dml.ManipulationOption;
import cn.schoolwow.quickdao.util.ParametersUtil;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class FilterInstanceBySameUniqueKeyFlow
implements BusinessFlow {
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        this.shouldCheck(flowContext);
        this.filterInstanceBySameUniqueKey(flowContext);
    }

    public String name() {
        return "\u8fc7\u6ee4\u552f\u4e00\u7ea6\u675f\u503c\u76f8\u540c\u7684\u5b9e\u4f8b";
    }

    private void shouldCheck(FlowContext flowContext) {
        CheckStrategy checkStrategy;
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig)flowContext.checkData("quickDAOConfig");
        ManipulationOption manipulationOption = (ManipulationOption)flowContext.checkData("manipulationOption");
        CheckStrategy checkStrategy2 = checkStrategy = null != manipulationOption.checkStrategy ? manipulationOption.checkStrategy : quickDAOConfig.databaseOption.checkStrategy;
        if (CheckStrategy.None.equals((Object)checkStrategy)) {
            flowContext.brokenCurrentFlow("\u6839\u636e\u5b57\u6bb5\u7ea6\u675f\u7b56\u7565,\u8df3\u8fc7\u8fc7\u6ee4\u552f\u4e00\u7ea6\u675f\u503c\u76f8\u540c\u7684\u5b9e\u4f8b");
        }
        Entity entity = (Entity)flowContext.checkData("entity");
        if (entity.uniqueProperties.isEmpty()) {
            flowContext.brokenCurrentFlow("\u5b9e\u4f8b\u65e0\u552f\u4e00\u7ea6\u675f\u5b57\u6bb5,\u8df3\u8fc7\u8fc7\u6ee4\u552f\u4e00\u7ea6\u675f\u503c\u76f8\u540c\u7684\u5b9e\u4f8b");
        }
    }

    private void filterInstanceBySameUniqueKey(FlowContext flowContext) {
        Entity entity = (Entity)flowContext.checkData("entity");
        Object[] instances = (Object[])flowContext.checkData("instances");
        Map instanceReasonMap = (Map)flowContext.getData("instanceReasonMap", new LinkedHashMap());
        HashSet<String> uniqueKeyValueSet = new HashSet<String>();
        StringBuilder uniqueKeyValueBuilder = new StringBuilder();
        ArrayList<Object> objectList = new ArrayList<Object>(Arrays.asList(instances));
        Iterator iterator = objectList.iterator();
        while (iterator.hasNext()) {
            Object instance = iterator.next();
            uniqueKeyValueBuilder.setLength(0);
            for (Property uniqueFieldProperty : entity.uniqueProperties) {
                Object value = ParametersUtil.getFieldValueFromInstance(instance, uniqueFieldProperty.name);
                uniqueKeyValueBuilder.append(value + "|");
            }
            String uniqueKeyValue = uniqueKeyValueBuilder.toString();
            if (uniqueKeyValueSet.contains(uniqueKeyValue)) {
                String reason = "\u5b58\u5728\u76f8\u540c\u552f\u4e00\u7ea6\u675f\u5b9e\u4f8b!\u552f\u4e00\u7ea6\u675f:" + uniqueKeyValue;
                if (!instanceReasonMap.containsKey(instance)) {
                    instanceReasonMap.put(instance, reason);
                } else {
                    String oldReason = (String)instanceReasonMap.get(instance);
                    instanceReasonMap.put(instance, oldReason + ";" + reason);
                }
                iterator.remove();
                continue;
            }
            uniqueKeyValueSet.add(uniqueKeyValue);
        }
        if (objectList.isEmpty()) {
            flowContext.putData("effect", (Object)0);
            flowContext.broken("\u6839\u636e\u552f\u4e00\u7ea6\u675f\u8fc7\u6ee4\u6570\u636e\u540e\u5b9e\u4f8b\u5217\u8868\u4e3a\u7a7a");
        }
        flowContext.putTemporaryData("instances", (Object)objectList.toArray(new Object[0]));
    }
}

