/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.flow.dml.instance.delete.common;

import cn.schoolwow.quickdao.domain.external.Entity;
import cn.schoolwow.quickdao.domain.external.Property;
import cn.schoolwow.quickdao.domain.external.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.internal.common.GetStatementSupplier;
import cn.schoolwow.quickdao.domain.internal.dml.GetBatchParametersSupplier;
import cn.schoolwow.quickdao.domain.internal.dml.ManipulationOption;
import cn.schoolwow.quickdao.flow.common.GetAndCacheStatementFlow;
import cn.schoolwow.quickdao.flow.executor.ExecuteBatchUpdateConnectionFlow;
import cn.schoolwow.quickdao.util.ParametersUtil;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import java.util.ArrayList;
import java.util.List;

public class DeleteByMultipleUniqueKeyFlow
implements BusinessFlow {
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        this.setStatement(flowContext);
        this.setParameters(flowContext);
        this.executeStatement(flowContext);
    }

    public String name() {
        return "\u6839\u636e\u591a\u4e2a\u552f\u4e00\u7ea6\u675f\u5b57\u6bb5\u5220\u9664\u5b9e\u4f8b";
    }

    private void setStatement(FlowContext flowContext) {
        final QuickDAOConfig quickDAOConfig = (QuickDAOConfig)flowContext.checkData("quickDAOConfig");
        final Entity entity = (Entity)flowContext.checkData("entity");
        flowContext.startFlow((BusinessFlow)new GetAndCacheStatementFlow()).putReturnData("sqlCacheName", (Object)("deleteByMultipleUniqueKey_" + entity.tableName)).putTemporaryData("getStatementSupplier", (Object)new GetStatementSupplier(){

            @Override
            public String getStatement() {
                StringBuilder sqlBuilder = new StringBuilder();
                sqlBuilder.append("delete from " + quickDAOConfig.databaseContext.databaseProvider.escape(entity.tableName) + " where ");
                for (Property uniqueKeyProperty : entity.uniqueProperties) {
                    sqlBuilder.append(quickDAOConfig.databaseContext.databaseProvider.escape(uniqueKeyProperty.column) + " = ? and ");
                }
                sqlBuilder.deleteCharAt(sqlBuilder.length() - 4);
                return sqlBuilder.toString();
            }
        }).execute();
    }

    public void setParameters(FlowContext flowContext) {
        Entity entity = (Entity)flowContext.checkData("entity");
        Object instance = flowContext.getData("instance");
        ArrayList<Object> parameters = new ArrayList<Object>();
        for (Property uniqueProperty : entity.uniqueProperties) {
            Object value = ParametersUtil.getFieldValueFromInstance(instance, uniqueProperty.name);
            if (null == value) {
                throw new IllegalArgumentException("\u552f\u4e00\u7ea6\u675f\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a!\u5b9e\u4f53\u7c7b:" + entity.clazz.getName() + ",\u5b57\u6bb5\u540d:" + uniqueProperty.name);
            }
            parameters.add(value);
        }
        flowContext.putTemporaryData("parameters", parameters);
    }

    private void executeStatement(final FlowContext flowContext) {
        ManipulationOption manipulationOption = (ManipulationOption)flowContext.checkData("manipulationOption");
        final Object[] instances = (Object[])flowContext.getData("instances", (Object)new Object[]{flowContext.checkData("instance")});
        flowContext.startFlow((BusinessFlow)new ExecuteBatchUpdateConnectionFlow()).putTemporaryData("perBatchCount", (Object)manipulationOption.perBatchCount).putTemporaryData("name", (Object)"\u6279\u5904\u7406\u6839\u636e\u552f\u4e00\u7ea6\u675f\u5b57\u6bb5\u5220\u9664\u5b9e\u4f8b\u6570\u7ec4").putTemporaryData("size", (Object)instances.length).putTemporaryData("getBatchParametersSupplier", (Object)new GetBatchParametersSupplier(){

            @Override
            public List<Object> getBatchParameters(Integer index) throws Exception {
                flowContext.putTemporaryData("instance", instances[index]);
                DeleteByMultipleUniqueKeyFlow.this.setParameters(flowContext);
                List parameters = (List)flowContext.checkData("parameters");
                return parameters;
            }
        }).execute();
    }
}

