/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.flow.dml.instance.insert.get;

import cn.schoolwow.quickdao.domain.external.Entity;
import cn.schoolwow.quickdao.domain.external.Property;
import cn.schoolwow.quickdao.flow.dml.instance.insert.get.GetSinglePropertyValueListFlow;
import cn.schoolwow.quickdao.flow.dml.instance.insert.get.GetUniqueKeyValueListFlow;
import cn.schoolwow.quickdao.util.ParametersUtil;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DistinguishExistInstanceFlow
implements BusinessFlow {
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        Entity entity = (Entity)flowContext.checkData("entity");
        HashSet existInstanceSet = new HashSet();
        flowContext.putTemporaryData("existInstanceSet", existInstanceSet);
        if (entity.uniqueProperties.size() == 1) {
            this.distinguishBySingleProperty(entity.uniqueProperties.get(0), flowContext);
        }
        if (null != entity.id) {
            this.distinguishBySingleProperty(entity.id, flowContext);
        }
        if (entity.uniqueProperties.size() > 1) {
            this.distinguishByUniqueKey(flowContext);
        }
        this.setNotExistInstanceSet(flowContext);
        Set notExistInstanceSet = (Set)flowContext.getData("notExistInstanceSet");
        if (existInstanceSet.isEmpty() && notExistInstanceSet.isEmpty()) {
            throw new IllegalArgumentException("\u903b\u8f91\u6267\u884c\u5f02\u5e38!\u5b58\u5728\u5b9e\u4f8b\u548c\u4e0d\u5b58\u5728\u5b9e\u4f8b\u4e2a\u6570\u90fd\u4e3a0!");
        }
        flowContext.putTemporaryData("existInstances", (Object)existInstanceSet.toArray(new Object[0]));
        flowContext.putTemporaryData("notExistInstances", (Object)notExistInstanceSet.toArray(new Object[0]));
        flowContext.removeData("existInstanceSet");
        flowContext.removeData("notExistInstanceSet");
    }

    public String name() {
        return "\u533a\u5206\u5b9e\u4f8b\u662f\u5426\u5b58\u5728";
    }

    private void distinguishBySingleProperty(Property singleProperty, FlowContext flowContext) {
        Set existInstanceSet = (Set)flowContext.getData("existInstanceSet");
        Object[] instances = (Object[])flowContext.checkData("instances");
        flowContext.startFlow((BusinessFlow)new GetSinglePropertyValueListFlow()).putTemporaryData("singleProperty", (Object)singleProperty).execute();
        List singlePropertyValueList = (List)flowContext.getData("singlePropertyValueList");
        if (singlePropertyValueList.isEmpty()) {
            return;
        }
        for (int i = 0; i < instances.length; ++i) {
            Object instance = instances[i];
            String singlePropertyValue = ParametersUtil.getFieldValueFromInstance(instance, singleProperty.name).toString();
            if (null == singlePropertyValue) {
                throw new IllegalArgumentException("\u5b9e\u4f8b\u6307\u5b9a\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a!\u5b9e\u4f53\u7c7b:" + instance.getClass().getName() + ",\u5b57\u6bb5\u540d:" + singleProperty.name);
            }
            if (!singlePropertyValueList.contains(singlePropertyValue)) continue;
            existInstanceSet.add(instance);
        }
    }

    private void distinguishByUniqueKey(FlowContext flowContext) {
        Set existInstanceSet = (Set)flowContext.getData("existInstanceSet");
        Entity entity = (Entity)flowContext.checkData("entity");
        Object[] instances = (Object[])flowContext.checkData("instances");
        flowContext.executeFlowList(new BusinessFlow[]{new GetUniqueKeyValueListFlow()});
        List uniqueKeyValueList = (List)flowContext.getData("uniqueKeyValueList");
        if (uniqueKeyValueList.isEmpty()) {
            return;
        }
        StringBuilder uniqueFieldNameValueBuilder = new StringBuilder();
        for (int i = 0; i < instances.length; ++i) {
            uniqueFieldNameValueBuilder.setLength(0);
            Object instance = instances[i];
            for (Property uniqueProperty : entity.uniqueProperties) {
                Object value = ParametersUtil.getFieldValueFromInstance(instance, uniqueProperty.name);
                if (null == value) {
                    throw new IllegalArgumentException("\u5b9e\u4f8b\u552f\u4e00\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a!\u5b9e\u4f53\u7c7b:" + instance.getClass().getName() + ",\u5b57\u6bb5\u540d:" + uniqueProperty.name);
                }
                uniqueFieldNameValueBuilder.append(value + "|");
            }
            if (!uniqueKeyValueList.contains(uniqueFieldNameValueBuilder.toString())) continue;
            existInstanceSet.add(instance);
        }
    }

    private void setNotExistInstanceSet(FlowContext flowContext) {
        Set existInstanceSet = (Set)flowContext.getData("existInstanceSet");
        Object[] instances = (Object[])flowContext.checkData("instances");
        if (existInstanceSet.isEmpty()) {
            flowContext.putData("notExistInstanceSet", new HashSet<Object>(Arrays.asList(instances)));
            return;
        }
        HashSet<Object> notExistInstanceSet = new HashSet<Object>();
        for (int i = 0; i < instances.length; ++i) {
            if (existInstanceSet.contains(instances[i])) continue;
            notExistInstanceSet.add(instances[i]);
        }
        flowContext.putData("notExistInstanceSet", notExistInstanceSet);
    }
}

