/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.flow.dml.instance.update.common;

import cn.schoolwow.quickdao.domain.external.Entity;
import cn.schoolwow.quickdao.domain.external.Property;
import cn.schoolwow.quickdao.domain.external.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.internal.common.GetStatementSupplier;
import cn.schoolwow.quickdao.flow.dml.instance.common.SetInstanceStatementFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import java.util.List;

public class SetUpdateInstanceByUniqueKeyStatementFlow
implements BusinessFlow {
    public void executeBusinessFlow(final FlowContext flowContext) throws Exception {
        final QuickDAOConfig quickDAOConfig = (QuickDAOConfig)flowContext.checkData("quickDAOConfig");
        final Entity entity = (Entity)flowContext.checkData("entity");
        if (entity.uniqueProperties.isEmpty()) {
            throw new IllegalArgumentException("\u6307\u5b9a\u5b9e\u4f53\u7c7b\u65e0\u552f\u4e00\u6027\u7ea6\u675f!\u8868\u540d:" + entity.tableName + ",\u7c7b\u540d:" + entity.clazz.getName());
        }
        flowContext.startFlow((BusinessFlow)new SetInstanceStatementFlow()).putReturnData("sqlCacheName", (Object)("updateByUniqueKey_" + entity.tableName + "_" + quickDAOConfig.databaseContext.databaseProvider.name())).putTemporaryData("getStatementSupplier", (Object)new GetStatementSupplier(){

            @Override
            public String getStatement() {
                List propertyList = (List)flowContext.checkData("propertyList");
                StringBuilder sqlBuilder = new StringBuilder();
                sqlBuilder.append("update " + quickDAOConfig.databaseContext.databaseProvider.escape(entity.tableName) + " set ");
                for (Property property : propertyList) {
                    if (property.id || property.createdAt || entity.uniqueProperties.contains(property)) continue;
                    sqlBuilder.append(quickDAOConfig.databaseContext.databaseProvider.escape(property.column) + " = " + (null == property.function ? "?" : property.function) + ",");
                }
                sqlBuilder.deleteCharAt(sqlBuilder.length() - 1);
                sqlBuilder.append(" where ");
                for (Property property : entity.properties) {
                    if (property.id || !entity.uniqueProperties.contains(property)) continue;
                    sqlBuilder.append(quickDAOConfig.databaseContext.databaseProvider.escape(property.column) + " = ? and ");
                }
                sqlBuilder.delete(sqlBuilder.length() - 5, sqlBuilder.length());
                return sqlBuilder.toString();
            }
        }).execute();
    }

    public String name() {
        return "\u8bbe\u7f6e\u6839\u636e\u552f\u4e00\u5b57\u6bb5\u5b57\u6bb5\u66f4\u65b0\u5b9e\u4f8b\u7684SQL\u8bed\u53e5";
    }
}

