/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.flow.dml.json.insert.get;

import cn.schoolwow.quickdao.domain.external.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.internal.common.ResultSetConsumer;
import cn.schoolwow.quickdao.domain.internal.dml.ManipulationOption;
import cn.schoolwow.quickdao.flow.executor.ExecuteQueryConnectionFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.sql.ResultSet;
import java.util.ArrayList;

public class GetUniqueFieldValueListFlow
implements BusinessFlow {
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        this.setStatement(flowContext);
        JSONArray instances = (JSONArray)flowContext.checkData("instances");
        for (int i = 0; i < instances.size(); ++i) {
            flowContext.putTemporaryData("instance", (Object)instances.getJSONObject(i));
            this.setParameters(flowContext);
            this.executeStatement(flowContext);
            flowContext.removeData("instance");
        }
    }

    public String name() {
        return "\u6839\u636e\u591a\u4e2a\u552f\u4e00\u5b57\u6bb5\u67e5\u8be2\u8bb0\u5f55\u5b57\u6bb5\u503c";
    }

    private void setStatement(FlowContext flowContext) {
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig)flowContext.checkData("quickDAOConfig");
        String tableName = (String)flowContext.checkData("tableName");
        ManipulationOption manipulationOption = (ManipulationOption)flowContext.checkData("manipulationOption");
        StringBuilder sqlBuilder = new StringBuilder("select");
        for (String uniqueFieldName : manipulationOption.uniqueFieldNames) {
            sqlBuilder.append(" " + quickDAOConfig.databaseContext.databaseProvider.escape(uniqueFieldName) + ",");
        }
        sqlBuilder.deleteCharAt(sqlBuilder.length() - 1);
        sqlBuilder.append(" from " + quickDAOConfig.databaseContext.databaseProvider.escape(tableName) + " where");
        for (String uniqueFieldName : manipulationOption.uniqueFieldNames) {
            sqlBuilder.append(" " + quickDAOConfig.databaseContext.databaseProvider.escape(uniqueFieldName) + " = ? and");
        }
        sqlBuilder.delete(sqlBuilder.length() - 4, sqlBuilder.length());
        flowContext.putTemporaryData("sql", (Object)sqlBuilder.toString());
    }

    private void setParameters(FlowContext flowContext) {
        JSONObject instance = (JSONObject)flowContext.checkData("instance");
        ManipulationOption manipulationOption = (ManipulationOption)flowContext.checkData("manipulationOption");
        ArrayList<Object> parameters = new ArrayList<Object>();
        for (String uniqueFieldName : manipulationOption.uniqueFieldNames) {
            parameters.add(instance.get((Object)uniqueFieldName));
        }
        flowContext.putTemporaryData("parameters", parameters);
    }

    private void executeStatement(final FlowContext flowContext) {
        final ManipulationOption manipulationOption = (ManipulationOption)flowContext.checkData("manipulationOption");
        final ArrayList uniqueFieldValueList = new ArrayList();
        final StringBuilder uniqueFieldNameValueBuilder = new StringBuilder();
        flowContext.startFlow((BusinessFlow)new ExecuteQueryConnectionFlow()).putTemporaryData("name", (Object)"\u6839\u636e\u591a\u4e2a\u552f\u4e00\u5b57\u6bb5\u67e5\u8be2\u8bb0\u5f55\u5b57\u6bb5\u503c").putReturnData("resultSetConsumer", (Object)new ResultSetConsumer(){

            @Override
            public void consumeResultSet(ResultSet resultSet) throws Exception {
                while (resultSet.next()) {
                    uniqueFieldNameValueBuilder.setLength(0);
                    for (String uniqueFieldName : manipulationOption.uniqueFieldNames) {
                        uniqueFieldNameValueBuilder.append(resultSet.getString(uniqueFieldName) + "|");
                    }
                    uniqueFieldValueList.add(uniqueFieldNameValueBuilder.toString());
                }
                flowContext.putTemporaryData("uniqueFieldValueList", (Object)uniqueFieldValueList);
            }
        }).execute();
    }
}

