/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.flow.dql.exist.common;

import cn.schoolwow.quickdao.domain.external.Entity;
import cn.schoolwow.quickdao.domain.external.Property;
import cn.schoolwow.quickdao.domain.external.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.internal.common.ResultSetConsumer;
import cn.schoolwow.quickdao.flow.executor.ExecuteQueryConnectionFlow;
import cn.schoolwow.quickdao.util.ParametersUtil;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import java.sql.ResultSet;
import java.util.ArrayList;

public class GetCountByUniqueKeyFlow
implements BusinessFlow {
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        this.setStatement(flowContext);
        this.setParameters(flowContext);
        this.executeStatement(flowContext);
    }

    public String name() {
        return "\u6839\u636e\u552f\u4e00\u6027\u7ea6\u675f\u67e5\u8be2\u8bb0\u5f55\u4e2a\u6570";
    }

    private void setStatement(FlowContext flowContext) {
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig)flowContext.checkData("quickDAOConfig");
        Entity entity = (Entity)flowContext.checkData("entity");
        String key = "selectCountByUniqueKey_" + entity.tableName + "_" + quickDAOConfig.databaseContext.databaseProvider.name();
        if (!quickDAOConfig.databaseContext.statementCache.containsKey(key)) {
            StringBuilder sqlBuilder = new StringBuilder();
            sqlBuilder.append("select count(1) from " + quickDAOConfig.databaseContext.databaseProvider.escape(entity.tableName) + " where ");
            for (Property property : entity.uniqueProperties) {
                sqlBuilder.append(quickDAOConfig.databaseContext.databaseProvider.escape(property.column) + "= " + (null == property.function ? "?" : property.function) + " and ");
            }
            sqlBuilder.delete(sqlBuilder.length() - 5, sqlBuilder.length());
            quickDAOConfig.databaseContext.statementCache.put(key, sqlBuilder.toString());
        }
        String sql = quickDAOConfig.databaseContext.statementCache.get(key);
        flowContext.putTemporaryData("sql", (Object)sql);
    }

    private void setParameters(FlowContext flowContext) {
        Entity entity = (Entity)flowContext.checkData("entity");
        Object instance = flowContext.checkData("instance");
        ArrayList<Object> parameters = new ArrayList<Object>();
        for (Property property : entity.uniqueProperties) {
            Object value = ParametersUtil.getFieldValueFromInstance(instance, property.name);
            parameters.add(value);
        }
        flowContext.putTemporaryData("parameters", parameters);
    }

    private void executeStatement(final FlowContext flowContext) {
        flowContext.startFlow((BusinessFlow)new ExecuteQueryConnectionFlow()).putTemporaryData("name", (Object)"\u6839\u636e\u552f\u4e00\u6027\u7ea6\u675f\u67e5\u8be2\u8bb0\u5f55\u4e2a\u6570").putReturnData("resultSetConsumer", (Object)new ResultSetConsumer(){

            @Override
            public void consumeResultSet(ResultSet resultSet) throws Exception {
                if (resultSet.next()) {
                    flowContext.putData("count", (Object)resultSet.getLong(1));
                }
            }
        }).execute();
    }
}

