/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.flow.dql.fetch;

import cn.schoolwow.quickdao.domain.external.Entity;
import cn.schoolwow.quickdao.domain.external.Property;
import cn.schoolwow.quickdao.domain.external.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.internal.common.GetStatementSupplier;
import cn.schoolwow.quickdao.domain.internal.common.ResultSetConsumer;
import cn.schoolwow.quickdao.flow.common.GetAndCacheStatementFlow;
import cn.schoolwow.quickdao.flow.dql.response.common.GetResultSetArrayFlow;
import cn.schoolwow.quickdao.flow.executor.ExecuteQueryConnectionFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import java.sql.ResultSet;
import java.util.ArrayList;

public class FetchNullFlow
implements BusinessFlow {
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        this.setStatement(flowContext);
        this.setParameters(flowContext);
        this.executeStatement(flowContext);
    }

    public String name() {
        return "\u67e5\u8be2\u5b57\u6bb5\u4e3aNULL\u7684\u8bb0\u5f55";
    }

    private void setStatement(FlowContext flowContext) {
        final QuickDAOConfig quickDAOConfig = (QuickDAOConfig)flowContext.checkData("quickDAOConfig");
        final Entity entity = (Entity)flowContext.checkData("entity");
        final String column = (String)flowContext.checkData("column");
        String sqlCacheName = "fetchNull_" + entity.tableName + "_" + column + "_" + quickDAOConfig.databaseContext.databaseProvider.name();
        flowContext.startFlow((BusinessFlow)new GetAndCacheStatementFlow()).putCurrentCompositeFlowData("sqlCacheName", (Object)sqlCacheName).putTemporaryData("getStatementSupplier", (Object)new GetStatementSupplier(){

            @Override
            public String getStatement() {
                StringBuilder sqlBuilder = new StringBuilder("select ");
                for (Property property : entity.properties) {
                    sqlBuilder.append(quickDAOConfig.databaseContext.databaseProvider.escape(property.column) + ",");
                }
                sqlBuilder.deleteCharAt(sqlBuilder.length() - 1);
                sqlBuilder.append(" from " + quickDAOConfig.databaseContext.databaseProvider.escape(entity.tableName));
                sqlBuilder.append(" where " + quickDAOConfig.databaseContext.databaseProvider.escape(column) + " is null");
                return sqlBuilder.toString();
            }
        }).execute();
    }

    private void setParameters(FlowContext flowContext) {
        flowContext.putTemporaryData("parameters", new ArrayList());
    }

    private void executeStatement(final FlowContext flowContext) throws Exception {
        flowContext.startFlow((BusinessFlow)new ExecuteQueryConnectionFlow()).putTemporaryData("name", (Object)"\u67e5\u8be2\u5b57\u6bb5\u4e3aNULL\u7684\u8bb0\u5f55").putReturnData("resultSetConsumer", (Object)new ResultSetConsumer(){

            @Override
            public void consumeResultSet(ResultSet resultSet) throws Exception {
                flowContext.startFlow((BusinessFlow)new GetResultSetArrayFlow()).putTemporaryData("resultSet", (Object)resultSet).execute();
            }
        }).execute();
    }
}

