/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.flow.dql.response.common;

import cn.schoolwow.quickdao.domain.external.Entity;
import cn.schoolwow.quickdao.domain.external.Property;
import cn.schoolwow.quickdao.domain.external.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.external.dql.QueryColumnTypeMapping;
import cn.schoolwow.quickdao.domain.internal.DatabaseType;
import cn.schoolwow.quickdao.domain.internal.dql.common.QueryContext;
import cn.schoolwow.quickdao.domain.internal.dql.subquery.SubQueryOption;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Map;

public class GetResultSetArrayFlow
implements BusinessFlow {
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        this.setResultSetPropertyList(flowContext);
        this.matchEntity(flowContext);
        this.matchClazz(flowContext);
        this.matchQueryContext(flowContext);
        this.matchQueryColumnTypeMapping(flowContext);
        this.setResultSetArray(flowContext);
    }

    public String name() {
        return "\u83b7\u53d6ResultSet\u53d8\u4e3aJSONArray";
    }

    private void setResultSetPropertyList(FlowContext flowContext) throws SQLException {
        ResultSet resultSet = (ResultSet)flowContext.checkData("resultSet");
        ResultSetMetaData metaData = resultSet.getMetaData();
        Property[] resultSetPropertyArray = new Property[metaData.getColumnCount()];
        for (int i = 1; i <= resultSetPropertyArray.length; ++i) {
            resultSetPropertyArray[i - 1] = new Property();
            resultSetPropertyArray[i - 1].columnLabel = metaData.getColumnLabel(i);
            resultSetPropertyArray[i - 1].column = metaData.getColumnName(i);
            resultSetPropertyArray[i - 1].columnType = metaData.getColumnTypeName(i);
            resultSetPropertyArray[i - 1].className = metaData.getColumnClassName(i);
            resultSetPropertyArray[i - 1].entity = new Entity();
            resultSetPropertyArray[i - 1].entity.tableName = metaData.getTableName(i);
        }
        flowContext.putData("resultSetPropertyArray", (Object)resultSetPropertyArray);
    }

    private void matchEntity(FlowContext flowContext) {
        Entity entity = (Entity)flowContext.getData("entity");
        if (null == entity) {
            return;
        }
        Property[] resultSetPropertyArray = (Property[])flowContext.checkData("resultSetPropertyArray");
        block0: for (Property property : entity.properties) {
            for (Property resultSetProperty : resultSetPropertyArray) {
                if (!resultSetProperty.entity.tableName.equalsIgnoreCase(entity.tableName) || !resultSetProperty.columnLabel.equalsIgnoreCase(property.name) && !resultSetProperty.columnLabel.equalsIgnoreCase(property.column)) continue;
                resultSetProperty.clazz = property.clazz;
                continue block0;
            }
        }
    }

    private void matchClazz(FlowContext flowContext) {
        Class clazz = (Class)flowContext.getData("clazz");
        if (null == clazz) {
            return;
        }
        String className = clazz.getName();
        if (className.startsWith("java.")) {
            return;
        }
        Property[] resultSetPropertyArray = (Property[])flowContext.checkData("resultSetPropertyArray");
        AccessibleObject[] fields = clazz.getDeclaredFields();
        Field.setAccessible(fields, true);
        block0: for (AccessibleObject field : fields) {
            for (Property resultSetProperty : resultSetPropertyArray) {
                if (!resultSetProperty.columnLabel.equalsIgnoreCase(((Field)field).getName())) continue;
                resultSetProperty.clazz = ((Field)field).getType();
                continue block0;
            }
        }
    }

    private void matchQueryContext(FlowContext flowContext) {
        QueryContext queryContext = (QueryContext)flowContext.getData("queryContext");
        if (null == queryContext) {
            return;
        }
        Property[] resultSetPropertyArray = (Property[])flowContext.checkData("resultSetPropertyArray");
        Entity entity = queryContext.queryOption.queryTableOption.entity;
        if (null != entity) {
            String tableAliasName = queryContext.queryOption.queryTableOption.tableAliasName;
            block0: for (Property property : entity.properties) {
                for (Property resultSetProperty : resultSetPropertyArray) {
                    if (!resultSetProperty.entity.tableName.equalsIgnoreCase(entity.tableName) || !resultSetProperty.columnLabel.equalsIgnoreCase(tableAliasName + "_" + property.column) && !resultSetProperty.column.equalsIgnoreCase(property.column)) continue;
                    resultSetProperty.clazz = property.clazz;
                    continue block0;
                }
            }
        }
        for (SubQueryOption subQueryOption : queryContext.queryOption.subQueryOptionList) {
            Entity entity2 = subQueryOption.subQueryTableOption.entity;
            if (null == entity2) continue;
            String tableAliasName = subQueryOption.subQueryTableOption.tableAliasName;
            block3: for (Property property : entity2.properties) {
                for (Property resultSetProperty : resultSetPropertyArray) {
                    if (!resultSetProperty.entity.tableName.equalsIgnoreCase(entity2.tableName) || !resultSetProperty.columnLabel.equalsIgnoreCase(tableAliasName + "_" + property.column) && !resultSetProperty.column.equalsIgnoreCase(property.column)) continue;
                    resultSetProperty.clazz = property.clazz;
                    continue block3;
                }
            }
        }
        flowContext.putTemporaryData("queryColumnTypeMapping", (Object)queryContext.queryOption.queryColumnOption.queryColumnTypeMapping);
        flowContext.putTemporaryData("queryColumnTypeMap", queryContext.queryOption.queryColumnOption.queryColumnTypeMap);
    }

    private void matchQueryColumnTypeMapping(FlowContext flowContext) {
        Property[] resultSetPropertyArray = (Property[])flowContext.checkData("resultSetPropertyArray");
        Map queryColumnTypeMap = (Map)flowContext.getData("queryColumnTypeMap");
        if (null != queryColumnTypeMap) {
            for (Property resultSetProperty : resultSetPropertyArray) {
                if (!queryColumnTypeMap.containsKey(resultSetProperty.columnLabel) && !queryColumnTypeMap.containsKey(resultSetProperty.column)) continue;
                resultSetProperty.clazz = (Class)queryColumnTypeMap.get(resultSetProperty.columnLabel);
            }
        }
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig)flowContext.checkData("quickDAOConfig");
        QueryColumnTypeMapping queryColumnTypeMapping = (QueryColumnTypeMapping)flowContext.getData("queryColumnTypeMapping");
        if (null == queryColumnTypeMapping) {
            queryColumnTypeMapping = quickDAOConfig.entityOption.queryColumnTypeMapping;
        }
        if (null != queryColumnTypeMapping) {
            for (Property resultSetProperty : resultSetPropertyArray) {
                Class type = queryColumnTypeMapping.columnTypeMapping(resultSetProperty);
                if (null == type) continue;
                resultSetProperty.clazz = type;
            }
        }
    }

    private void setResultSetArray(FlowContext flowContext) throws SQLException {
        JSONArray resultSetArray;
        DatabaseType databaseType = (DatabaseType)((Object)flowContext.checkData("databaseType"));
        ResultSet resultSet = (ResultSet)flowContext.checkData("resultSet");
        Long count = (Long)flowContext.getData("count");
        Property[] resultSetPropertyArray = (Property[])flowContext.checkData("resultSetPropertyArray");
        JSONArray jSONArray = resultSetArray = null == count ? new JSONArray() : new JSONArray(count.intValue());
        while (resultSet.next()) {
            JSONObject resultSetObject = new JSONObject();
            block14: for (Property property : resultSetPropertyArray) {
                if (null == property.clazz) {
                    resultSetObject.put(property.columnLabel, resultSet.getObject(property.columnLabel));
                    continue;
                }
                switch (property.clazz.getName()) {
                    case "java.util.Date": {
                        resultSetObject.put(property.columnLabel, (Object)resultSet.getDate(property.columnLabel));
                        continue block14;
                    }
                    case "com.alibaba.fastjson.JSONObject": {
                        String jsonString = resultSet.getString(property.columnLabel);
                        resultSetObject.put(property.columnLabel, (Object)JSON.parseObject((String)jsonString));
                        continue block14;
                    }
                    case "com.alibaba.fastjson.JSONArray": {
                        String jsonString = resultSet.getString(property.columnLabel);
                        resultSetObject.put(property.columnLabel, (Object)JSON.parseArray((String)jsonString));
                        continue block14;
                    }
                    default: {
                        switch (databaseType) {
                            case SQLite: 
                            case Postgresql: {
                                resultSetObject.put(property.columnLabel, resultSet.getObject(property.columnLabel));
                                continue block14;
                            }
                        }
                        Object value = resultSet.getObject(property.columnLabel);
                        if (null == value) continue block14;
                        resultSetObject.put(property.columnLabel, resultSet.getObject(property.columnLabel, property.clazz));
                    }
                }
            }
            resultSetArray.add((Object)resultSetObject);
        }
        flowContext.putData("resultSetArray", (Object)resultSetArray);
    }
}

