/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.flow.entity;

import cn.schoolwow.quickdao.domain.external.Entity;
import cn.schoolwow.quickdao.domain.external.Property;
import cn.schoolwow.quickdao.domain.external.QuickDAOConfig;
import cn.schoolwow.quickdao.flow.entity.annotation.ScanPropertyAnnotationFlow;
import cn.schoolwow.quickdao.flow.entity.annotation.ScanTableAnnotationFlow;
import cn.schoolwow.quickdao.flow.entity.scan.ScanEntityClassFlow;
import cn.schoolwow.quickdao.flow.entity.scan.ScanPackageClassFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

public class SetEntityMapFlow
implements BusinessFlow {
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        flowContext.printTrace(false);
        this.scanEntityMap(flowContext);
        this.handleDefinerEntityMap(flowContext);
        this.specialHandle(flowContext);
        this.handleEntityListener(flowContext);
        flowContext.printTrace(true);
    }

    public String name() {
        return "\u8bbe\u7f6e\u5b9e\u4f53\u7c7b\u4fe1\u606f";
    }

    private void scanEntityMap(FlowContext flowContext) {
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig)flowContext.checkData("quickDAOConfig");
        flowContext.executeFlowList(new BusinessFlow[]{new ScanEntityClassFlow(), new ScanPackageClassFlow()});
        for (Entity entity : quickDAOConfig.databaseContext.entityMap.values()) {
            flowContext.putTemporaryData("entity", (Object)entity);
            flowContext.executeFlowList(new BusinessFlow[]{new ScanPropertyAnnotationFlow(), new ScanTableAnnotationFlow()});
        }
    }

    private void handleDefinerEntityMap(FlowContext flowContext) {
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig)flowContext.checkData("quickDAOConfig");
        for (Entity entity : quickDAOConfig.entityOption.definerEntityMap.values()) {
            Entity targetEntity = quickDAOConfig.databaseContext.entityMap.get(entity.clazz.getName());
            if (null == targetEntity) continue;
            if (null != entity.tableName) {
                targetEntity.tableName = entity.tableName;
            }
            if (null != entity.comment) {
                targetEntity.comment = entity.comment;
            }
            targetEntity.indexFieldList.addAll(entity.indexFieldList);
            for (Property property : entity.properties) {
                Property targetProperty = targetEntity.getPropertyByFieldNameOrColumnName(property.name);
                if (null == targetProperty) continue;
                if (!property.id) {
                    targetProperty.id = true;
                }
                if (null != property.strategy) {
                    targetProperty.strategy = property.strategy;
                }
                if (null != property.columnType) {
                    targetProperty.columnType = property.columnType;
                }
                if (null != property.column) {
                    targetProperty.column = property.column;
                }
                if (null != property.comment) {
                    targetProperty.comment = property.comment;
                }
                if (null != property.notNull) {
                    targetProperty.notNull = property.notNull;
                }
                if (null != property.check) {
                    targetProperty.check = property.check;
                }
                if (null == property.defaultValue) continue;
                targetProperty.defaultValue = property.defaultValue;
            }
        }
    }

    private void specialHandle(FlowContext flowContext) {
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig)flowContext.checkData("quickDAOConfig");
        if ("H2".equalsIgnoreCase(quickDAOConfig.databaseContext.databaseProvider.name())) {
            for (Entity entity : quickDAOConfig.databaseContext.entityMap.values()) {
                entity.tableName = entity.tableName.toUpperCase();
                for (Property property : entity.properties) {
                    property.column = property.column.toUpperCase();
                }
            }
        }
    }

    private void handleEntityListener(FlowContext flowContext) {
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig)flowContext.checkData("quickDAOConfig");
        if (null == quickDAOConfig.entityOption.entityListener) {
            return;
        }
        for (Entity entity : quickDAOConfig.databaseContext.entityMap.values()) {
            quickDAOConfig.entityOption.entityListener.afterScanEntity(entity);
        }
    }
}

