/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.flow.entity.annotation;

import cn.schoolwow.quickdao.annotation.Comment;
import cn.schoolwow.quickdao.annotation.CompositeIndex;
import cn.schoolwow.quickdao.annotation.CompositeIndexes;
import cn.schoolwow.quickdao.annotation.UniqueField;
import cn.schoolwow.quickdao.domain.external.Entity;
import cn.schoolwow.quickdao.domain.external.IndexField;
import cn.schoolwow.quickdao.domain.external.Property;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import java.util.ArrayList;
import java.util.Arrays;

public class ScanTableAnnotationFlow
implements BusinessFlow {
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        UniqueField uniqueField;
        CompositeIndexes compositeIndexes;
        Entity entity = (Entity)flowContext.checkData("entity");
        Comment comment = this.getFirstAnnotation(entity.clazz, Comment.class);
        if (null != comment) {
            entity.comment = comment.value();
        }
        ArrayList<CompositeIndex> compositeIndexList = new ArrayList<CompositeIndex>();
        CompositeIndex compositeIndexAnno = this.getFirstAnnotation(entity.clazz, CompositeIndex.class);
        if (null != compositeIndexAnno) {
            compositeIndexList.add(compositeIndexAnno);
        }
        if (null != (compositeIndexes = this.getFirstAnnotation(entity.clazz, CompositeIndexes.class))) {
            compositeIndexList.addAll(Arrays.asList(compositeIndexes.value()));
        }
        if (compositeIndexList.size() > 0) {
            int indexFieldNameCount = 0;
            for (CompositeIndex compositeIndex : compositeIndexList) {
                if (compositeIndex.columns().length == 0) continue;
                IndexField indexField = new IndexField();
                indexField.tableName = entity.tableName;
                indexField.indexType = compositeIndex.indexType();
                indexField.using = compositeIndex.using();
                for (String column : compositeIndex.columns()) {
                    indexField.columns.add(entity.getColumnNameByFieldName(column));
                }
                indexField.comment = compositeIndex.comment();
                indexField.indexName = !compositeIndex.indexName().isEmpty() ? compositeIndex.indexName() : entity.tableName + "_" + indexField.indexType.name().toLowerCase() + indexFieldNameCount++;
                entity.indexFieldList.add(indexField);
            }
        }
        if (null != (uniqueField = this.getFirstAnnotation(entity.clazz, UniqueField.class))) {
            for (String column : uniqueField.columns()) {
                Property property = entity.getPropertyByFieldNameOrColumnName(column);
                if (null == property) {
                    throw new IllegalArgumentException("UniqueField\u6ce8\u89e3\u53c2\u6570\u65e0\u6cd5\u5339\u914d\u5b57\u6bb5!\u7c7b:" + entity.clazz.getName() + ",\u5b57\u6bb5:" + column);
                }
                entity.uniqueProperties.add(property);
            }
        }
    }

    public String name() {
        return "\u626b\u63cf\u5b9e\u4f53\u7c7b\u6ce8\u89e3";
    }

    private <T> T getFirstAnnotation(Class clazz, Class<T> annotation) {
        T annotation1 = null;
        while (null != clazz && null == annotation1) {
            annotation1 = clazz.getDeclaredAnnotation(annotation);
            clazz = clazz.getSuperclass();
        }
        return annotation1;
    }
}

