/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.flow.entity.common;

import cn.schoolwow.quickdao.annotation.Ignore;
import cn.schoolwow.quickdao.domain.external.Entity;
import cn.schoolwow.quickdao.domain.internal.config.EntityOption;
import cn.schoolwow.quickdao.flow.entity.common.ShouldIgnoreClassFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import com.alibaba.fastjson.JSONArray;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Stack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetEntityAllFieldsFlow
implements BusinessFlow {
    private Logger logger = LoggerFactory.getLogger(GetEntityAllFieldsFlow.class);

    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        Entity entity = (Entity)flowContext.checkData("entity");
        ArrayList<AccessibleObject> fieldList = new ArrayList<AccessibleObject>();
        Class tempClass = entity.clazz;
        while (null != tempClass) {
            AccessibleObject[] fields = tempClass.getDeclaredFields();
            Field.setAccessible(fields, true);
            for (AccessibleObject field : fields) {
                if (Modifier.isStatic(((Field)field).getModifiers()) || Modifier.isFinal(((Field)field).getModifiers()) || Modifier.isTransient(((Field)field).getModifiers())) {
                    this.logger.trace("\u8df3\u8fc7\u5e38\u91cf\u6216\u9759\u6001\u53d8\u91cf,\u8be5\u5b57\u6bb5\u88abstatic\u6216\u8005final\u4fee\u9970!\u5b57\u6bb5\u540d:{}", (Object)((Field)field).getName());
                    continue;
                }
                if (field.getDeclaredAnnotation(Ignore.class) != null) {
                    this.logger.trace("\u8df3\u8fc7\u5b9e\u4f53\u5c5e\u6027,\u8be5\u5c5e\u6027\u88abIgnore\u6ce8\u89e3\u4fee\u9970!\u5b57\u6bb5\u540d:{}", (Object)((Field)field).getName());
                    continue;
                }
                if (((Field)field).getType().isArray() || !((Field)field).getType().isPrimitive() && this.isCollection(((Field)field).getType())) {
                    this.logger.trace("\u8df3\u8fc7\u96c6\u5408\u7c7b\u578b!\u5b57\u6bb5\u540d:{}", (Object)((Field)field).getName());
                    continue;
                }
                boolean shouldIgnoreClass = (Boolean)flowContext.startFlow((BusinessFlow)new ShouldIgnoreClassFlow()).printTrace(false).putTemporaryData("clazz", ((Field)field).getType()).execute().checkData("shouldIgnoreClass");
                if (shouldIgnoreClass) {
                    this.logger.trace("\u8df3\u8fc7\u7528\u6237\u6307\u5b9a\u8fc7\u6ee4\u6761\u4ef6!\u5b57\u6bb5\u540d:{}", (Object)((Field)field).getName());
                    continue;
                }
                ((Field)field).setAccessible(true);
                fieldList.add(field);
            }
            if (null == (tempClass = tempClass.getSuperclass()) || !"java.lang.Object".equals(tempClass.getName())) continue;
            break;
        }
        flowContext.putTemporaryData("fieldList", fieldList);
    }

    public String name() {
        return "\u83b7\u53d6\u5b9e\u4f53\u7c7b\u6240\u6709\u5b57\u6bb5";
    }

    private boolean isCollection(Class clazz) {
        if (clazz.getName().equals(JSONArray.class.getName())) {
            return false;
        }
        Stack<Class<?>[]> stack = new Stack<Class<?>[]>();
        stack.push(clazz.getInterfaces());
        while (!stack.isEmpty()) {
            Class[] classes;
            for (Class _clazz : classes = (Class[])stack.pop()) {
                if (_clazz.getName().equals(Collection.class.getName())) {
                    return true;
                }
                Class<?>[] subClasses = _clazz.getInterfaces();
                if (null == subClasses || subClasses.length <= 0) continue;
                stack.push(subClasses);
            }
        }
        return false;
    }

    private static boolean shouldIgnoreClass(Class clazz, EntityOption entityOption) {
        if (clazz.isEnum()) {
            return true;
        }
        if (clazz.getAnnotation(Ignore.class) != null) {
            return true;
        }
        if (null != entityOption.ignoreClassList) {
            for (Class _clazz : entityOption.ignoreClassList) {
                if (!_clazz.getName().equals(clazz.getName())) continue;
                return true;
            }
        }
        if (null != entityOption.ignorePackageNameList) {
            for (String ignorePackageName : entityOption.ignorePackageNameList) {
                if (!clazz.getName().contains(ignorePackageName)) continue;
                return true;
            }
        }
        for (Class _clazz : entityOption.entityClassMap.keySet()) {
            if (!_clazz.getName().equals(clazz.getName())) continue;
            return true;
        }
        return null != entityOption.ignorePredicate && entityOption.ignorePredicate.test(clazz);
    }
}

