/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.flow.entity.scan;

import cn.schoolwow.quickdao.annotation.TableName;
import cn.schoolwow.quickdao.domain.external.Entity;
import cn.schoolwow.quickdao.domain.external.QuickDAOConfig;
import cn.schoolwow.quickdao.flow.entity.common.ShouldIgnoreClassFlow;
import cn.schoolwow.quickdao.util.StringUtil;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScanPackageClassFlow
implements BusinessFlow {
    private Logger logger = LoggerFactory.getLogger(ScanPackageClassFlow.class);

    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig)flowContext.checkData("quickDAOConfig");
        for (String packageName : quickDAOConfig.entityOption.packageNameMap.keySet()) {
            List<Class> packageClassList = this.scanPackageClassByPackageName(packageName, flowContext);
            for (Class packageClass : packageClassList) {
                Entity entity = new Entity();
                if (null != quickDAOConfig.entityOption.entityListener) {
                    entity.tableName = quickDAOConfig.entityOption.entityListener.getTableName(packageClass);
                }
                if (null == entity.tableName && null != packageClass.getDeclaredAnnotation(TableName.class)) {
                    entity.tableName = packageClass.getDeclaredAnnotation(TableName.class).value();
                }
                if (null == entity.tableName && packageName.length() + packageClass.getSimpleName().length() + 1 == packageClass.getName().length()) {
                    entity.tableName = quickDAOConfig.entityOption.packageNameMap.get(packageName) + StringUtil.camel2Underline(packageClass.getSimpleName());
                }
                if (null == entity.tableName) {
                    String prefix = packageClass.getName().substring(packageName.length() + 1, packageClass.getName().lastIndexOf(".")).replace(".", "_");
                    entity.tableName = quickDAOConfig.entityOption.packageNameMap.get(packageName) + prefix + "@" + StringUtil.camel2Underline(packageClass.getSimpleName());
                }
                entity.clazz = packageClass;
                quickDAOConfig.databaseContext.entityMap.put(packageClass.getName(), entity);
            }
        }
    }

    public String name() {
        return "\u626b\u63cf\u5b9e\u4f53\u7c7b\u5305";
    }

    private List<Class> scanPackageClassByPackageName(String packageName, FlowContext flowContext) {
        String packageNamePath = packageName.replace(".", "/");
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        URL url = classLoader.getResource(packageNamePath);
        if (url == null) {
            this.logger.warn("\u5305\u8def\u5f84\u4e0d\u5b58\u5728,\u5305\u540d:{}", (Object)packageName);
            return new ArrayList<Class>();
        }
        final ArrayList<String> classNameList = new ArrayList<String>();
        try {
            switch (url.getProtocol()) {
                case "file": {
                    File file = new File(url.getFile());
                    if (!file.isDirectory()) {
                        throw new IllegalArgumentException("\u5305\u540d\u4e0d\u662f\u5408\u6cd5\u7684\u6587\u4ef6\u5939!" + url.getFile());
                    }
                    final String indexOfString = packageName.replace(".", "/");
                    Files.walkFileTree(file.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                        @Override
                        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                            File f = file.toFile();
                            if (f.getName().endsWith(".class")) {
                                String path = f.getAbsolutePath().replace("\\", "/");
                                int startIndex = path.indexOf(indexOfString);
                                String className = path.substring(startIndex, path.length() - 6).replace("/", ".");
                                classNameList.add(className);
                            }
                            return FileVisitResult.CONTINUE;
                        }
                    });
                    break;
                }
                case "jar": {
                    JarFile jarFile;
                    JarURLConnection jarURLConnection = (JarURLConnection)url.openConnection();
                    if (null == jarURLConnection || null == (jarFile = jarURLConnection.getJarFile())) break;
                    Enumeration<JarEntry> jarEntries = jarFile.entries();
                    while (jarEntries.hasMoreElements()) {
                        JarEntry jarEntry = jarEntries.nextElement();
                        String jarEntryName = jarEntry.getName();
                        if (!jarEntryName.contains(packageNamePath) || !jarEntryName.endsWith(".class")) continue;
                        String className = jarEntryName.substring(0, jarEntryName.lastIndexOf(".")).replaceAll("/", ".");
                        classNameList.add(className);
                    }
                    break;
                }
            }
            ArrayList<Class> classList = new ArrayList<Class>(classNameList.size());
            for (String className : classNameList) {
                Class<?> clazz = classLoader.loadClass(className);
                boolean shouldIgnoreClass = (Boolean)flowContext.startFlow((BusinessFlow)new ShouldIgnoreClassFlow()).printTrace(false).putTemporaryData("clazz", clazz).execute().checkData("shouldIgnoreClass");
                if (shouldIgnoreClass) continue;
                classList.add(clazz);
            }
            return classList;
        }
        catch (Exception e) {
            throw new RuntimeException("\u8bfb\u53d6\u5b9e\u4f53\u7c7b\u4fe1\u606f\u65f6\u53d1\u751f\u5f02\u5e38!", e);
        }
    }
}

