/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.flow.executor;

import cn.schoolwow.quickdao.domain.external.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.external.entity.SqlLog;
import cn.schoolwow.quickdao.domain.internal.common.ResultSetConsumer;
import cn.schoolwow.quickdao.flow.executor.common.BeforeExecuteFlow;
import cn.schoolwow.quickdao.flow.executor.common.ExecuteFailFlow;
import cn.schoolwow.quickdao.flow.executor.common.InsertSqlLogFlow;
import cn.schoolwow.quickdao.flow.executor.common.SetPrepareStatementParameterFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecuteQueryConnectionFlow
implements BusinessFlow {
    private Logger logger = LoggerFactory.getLogger(ExecuteQueryConnectionFlow.class);

    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        flowContext.executeFlowList(new BusinessFlow[]{new BeforeExecuteFlow()});
        this.executeQuery(flowContext);
    }

    public String name() {
        return "\u6267\u884c\u67e5\u8be2\u8bed\u53e5";
    }

    private void executeQuery(FlowContext flowContext) throws Exception {
        String name = (String)flowContext.checkData("name");
        String sql = (String)flowContext.checkData("sql");
        String formatSQL = (String)flowContext.checkData("formatSQL");
        ResultSetConsumer resultSetConsumer = (ResultSetConsumer)flowContext.checkData("resultSetConsumer");
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig)flowContext.checkData("quickDAOConfig");
        flowContext.putTemporaryData("startTime", (Object)System.currentTimeMillis());
        try (Connection connection = quickDAOConfig.databaseContext.dataSource.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(sql);){
            flowContext.startFlow((BusinessFlow)new SetPrepareStatementParameterFlow()).putTemporaryData("preparedStatement", (Object)preparedStatement).execute();
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                flowContext.startFlow((BusinessFlow)new InsertSqlLogFlow()).putTemporaryData("sqlLogType", (Object)0).execute();
                SqlLog sqlLog = (SqlLog)flowContext.checkData("sqlLog");
                this.logger.debug("[\u67e5\u8be2]\u540d\u79f0:{},\u8017\u65f6:{}ms,\u6267\u884c\u8bed\u53e5:{}", new Object[]{name, sqlLog.getConsumeTime(), formatSQL});
                if (quickDAOConfig.logRecordOption.record && !"\u63d2\u5165SQL\u65e5\u5fd7".equalsIgnoreCase(name)) {
                    quickDAOConfig.logRecordOption.sqlRecordBuilder.append("[\u67e5\u8be2]\u540d\u79f0:" + name + ",\u8017\u65f6:" + sqlLog.getConsumeTime() + "ms,\u6267\u884c\u8bed\u53e5:" + formatSQL + "\r\n");
                }
                resultSetConsumer.consumeResultSet(resultSet);
            }
        }
        catch (Exception e) {
            flowContext.startFlow((BusinessFlow)new InsertSqlLogFlow()).next((BusinessFlow)new ExecuteFailFlow()).putTemporaryData("exception", (Object)e).putTemporaryData("sqlLogType", (Object)0).execute();
            throw e;
        }
        finally {
            flowContext.removeData("parameters");
        }
    }
}

