/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.flow.initial;

import cn.schoolwow.quickdao.domain.external.Entity;
import cn.schoolwow.quickdao.domain.external.IndexField;
import cn.schoolwow.quickdao.domain.external.Property;
import cn.schoolwow.quickdao.domain.external.QuickDAOConfig;
import cn.schoolwow.quickdao.flow.ddl.common.DeleteDatabaseEntityCacheFlow;
import cn.schoolwow.quickdao.flow.ddl.index.CreateIndexFlow;
import cn.schoolwow.quickdao.flow.ddl.property.CreateTableColumnFlow;
import cn.schoolwow.quickdao.flow.ddl.table.CreateForeignKeyFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import java.util.List;

public class CompareAndCreateColumnFlow
implements BusinessFlow {
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        this.setDatabaseEntity(flowContext);
        this.createColumn(flowContext);
        this.createIndex(flowContext);
    }

    public String name() {
        return "\u6bd4\u8f83\u5e76\u521b\u5efa\u5b9e\u4f53\u7c7b\u5217";
    }

    private void setDatabaseEntity(FlowContext flowContext) {
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig)flowContext.checkData("quickDAOConfig");
        Entity entity = (Entity)flowContext.checkData("entity");
        Entity databaseEntity = quickDAOConfig.dao.getDatabaseEntity(entity.tableName);
        if (null == databaseEntity) {
            flowContext.brokenCurrentFlow("\u6570\u636e\u5e93\u8868\u4e0d\u5b58\u5728!\u8868\u540d:" + entity.tableName);
            return;
        }
        if (!databaseEntity.tableName.equalsIgnoreCase(entity.tableName)) {
            throw new IllegalArgumentException("\u5b9e\u4f53\u7c7b\u83b7\u53d6\u9519\u8bef!\u9884\u671f\u8868\u540d:" + entity.tableName + ",\u5b9e\u9645\u8868\u540d:" + databaseEntity.tableName);
        }
        flowContext.putCurrentFlowData("databaseEntity", (Object)databaseEntity);
    }

    private void createColumn(FlowContext flowContext) {
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig)flowContext.checkData("quickDAOConfig");
        Entity entity = (Entity)flowContext.checkData("entity");
        Entity databaseEntity = (Entity)flowContext.checkData("databaseEntity");
        List<Property> sourcePropertyList = entity.properties;
        for (Property sourceProperty : sourcePropertyList) {
            Property targetProperty = databaseEntity.getPropertyByFieldNameOrColumnName(sourceProperty.column);
            if (null == targetProperty) {
                flowContext.startFlow((BusinessFlow)new CreateTableColumnFlow()).next((BusinessFlow)new DeleteDatabaseEntityCacheFlow()).putData("tableName", (Object)databaseEntity.tableName).putData("propertyOption", (Object)sourceProperty).execute();
            }
            if (null == sourceProperty.foreignKey || !quickDAOConfig.databaseOption.openForeignKey) continue;
            flowContext.startFlow((BusinessFlow)new CreateForeignKeyFlow()).next((BusinessFlow)new DeleteDatabaseEntityCacheFlow()).putData("tableName", (Object)databaseEntity.tableName).putData("propertyOption", (Object)sourceProperty).execute();
        }
    }

    private void createIndex(FlowContext flowContext) {
        Entity entity = (Entity)flowContext.checkData("entity");
        Entity databaseEntity = (Entity)flowContext.checkData("databaseEntity");
        for (IndexField indexField : entity.indexFieldList) {
            boolean exist = false;
            for (IndexField databaseIndexField : databaseEntity.indexFieldList) {
                if (!databaseIndexField.indexName.equalsIgnoreCase(indexField.indexName)) continue;
                exist = true;
                break;
            }
            if (exist) continue;
            flowContext.startFlow((BusinessFlow)new CreateIndexFlow()).next((BusinessFlow)new DeleteDatabaseEntityCacheFlow()).putData("indexField", (Object)indexField).putData("tableName", (Object)entity.tableName).execute();
        }
    }
}

