/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.flow.initial.datasource;

import cn.schoolwow.quickdao.domain.external.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.internal.DatabaseType;
import cn.schoolwow.quickdao.provider.DatabaseProvider;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import javax.sql.DataSource;

public class AutomaticCreateDatabase
implements BusinessFlow {
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        this.setDatabaseType(flowContext);
        this.setQueryDatabaseSQL(flowContext);
        this.setCreateDatabaseSQL(flowContext);
        this.executeCreateDatabase(flowContext);
    }

    public String name() {
        return "\u81ea\u52a8\u521b\u5efa\u6570\u636e\u5e93";
    }

    private void setDatabaseType(FlowContext flowContext) {
        DataSource dataSource = (DataSource)flowContext.checkData("dataSource");
        if (!(dataSource instanceof HikariDataSource)) {
            flowContext.broken("\u4e0d\u652f\u6301\u7684\u6570\u636e\u5e93\u8fde\u63a5\u6c60\u7c7b\u578b!\u7c7b\u540d:" + dataSource.getClass().getName());
        }
        HikariDataSource hikariDataSource = (HikariDataSource)dataSource;
        String jdbcUrl = hikariDataSource.getJdbcUrl();
        flowContext.putCurrentFlowData("jdbcUrl", (Object)jdbcUrl);
        List databaseProviderList = (List)flowContext.checkData("databaseProviderList");
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig)flowContext.checkData("quickDAOConfig");
        for (DatabaseProvider databaseProvider : databaseProviderList) {
            if (!jdbcUrl.contains("jdbc:" + databaseProvider.name())) continue;
            quickDAOConfig.databaseContext.databaseProvider = databaseProvider;
            break;
        }
        if (null == quickDAOConfig.databaseContext.databaseProvider) {
            throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u6570\u636e\u5e93\u7c7b\u578b!jdbcUrl:" + jdbcUrl);
        }
        flowContext.putCurrentFlowData("databaseType", (Object)quickDAOConfig.databaseContext.databaseProvider.getDatabaseType());
        flowContext.putCurrentFlowData("driverClassName", (Object)hikariDataSource.getDriverClassName());
        if (null != hikariDataSource.getUsername()) {
            flowContext.putCurrentFlowData("username", (Object)hikariDataSource.getUsername());
        }
        if (null != hikariDataSource.getPassword()) {
            flowContext.putCurrentFlowData("password", (Object)hikariDataSource.getPassword());
        }
        String databaseName = jdbcUrl.substring(jdbcUrl.lastIndexOf("/") + 1, jdbcUrl.contains("?") ? jdbcUrl.indexOf("?") : jdbcUrl.length());
        flowContext.putCurrentFlowData("databaseName", (Object)databaseName);
    }

    private void setQueryDatabaseSQL(FlowContext flowContext) {
        DatabaseType databaseType = (DatabaseType)((Object)flowContext.checkData("databaseType"));
        String queryDatabaseSQL = null;
        switch (databaseType) {
            case H2: {
                queryDatabaseSQL = "SELECT SCHEMA_NAME FROM INFORMATION_SCHEMA.SCHEMATA;";
                break;
            }
            case MariaDB: 
            case Mysql: {
                queryDatabaseSQL = "SHOW DATABASES;";
                break;
            }
            case Postgresql: {
                queryDatabaseSQL = "SELECT datname FROM pg_database;";
                break;
            }
            case SQLServer: {
                queryDatabaseSQL = "SELECT name FROM sys.databases;";
                break;
            }
            case Oracle: {
                queryDatabaseSQL = "SELECT table_name FROM user_tables;";
                break;
            }
            default: {
                flowContext.broken("\u4e0d\u652f\u6301\u7684\u6570\u636e\u5e93\u7c7b\u578b!" + databaseType.name());
            }
        }
        flowContext.putCurrentFlowData("queryDatabaseSQL", (Object)queryDatabaseSQL);
    }

    private void setCreateDatabaseSQL(FlowContext flowContext) {
        DatabaseType databaseType = (DatabaseType)((Object)flowContext.checkData("databaseType"));
        String databaseName = (String)flowContext.checkData("databaseName");
        String createDatabaseSQL = null;
        switch (databaseType) {
            case H2: {
                createDatabaseSQL = "CREATE SCHEMA " + databaseName + ";";
                break;
            }
            case MariaDB: 
            case Mysql: 
            case Postgresql: 
            case SQLServer: {
                createDatabaseSQL = "CREATE DATABASE " + databaseName + ";";
                break;
            }
            default: {
                flowContext.broken("\u4e0d\u652f\u6301\u7684\u6570\u636e\u5e93\u7c7b\u578b!" + databaseType.name());
            }
        }
        flowContext.putCurrentFlowData("createDatabaseSQL", (Object)createDatabaseSQL);
    }

    private void executeCreateDatabase(FlowContext flowContext) throws ClassNotFoundException, SQLException {
        String driverClassName = (String)flowContext.checkData("driverClassName");
        String jdbcUrl = (String)flowContext.checkData("jdbcUrl");
        String username = (String)flowContext.getData("username");
        String password = (String)flowContext.getData("password");
        String queryDatabaseSQL = (String)flowContext.checkData("queryDatabaseSQL");
        String createDatabaseSQL = (String)flowContext.checkData("createDatabaseSQL");
        String databaseName = (String)flowContext.checkData("databaseName");
        String rawJdbcUrl = jdbcUrl.substring(0, jdbcUrl.lastIndexOf("/") + 1);
        Class.forName(driverClassName);
        try (Connection connection = DriverManager.getConnection(rawJdbcUrl, username, password);){
            ResultSet resultSet = connection.prepareStatement(queryDatabaseSQL).executeQuery();
            boolean databaseExist = false;
            while (resultSet.next()) {
                String rowDatabaseName = resultSet.getString(1);
                if (!databaseName.equalsIgnoreCase(rowDatabaseName)) continue;
                databaseExist = true;
                break;
            }
            if (!databaseExist) {
                connection.prepareStatement(createDatabaseSQL).executeUpdate();
            }
        }
    }
}

