/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.util;

import cn.schoolwow.quickdao.domain.external.Property;
import java.lang.reflect.Field;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParametersUtil {
    private static Logger logger = LoggerFactory.getLogger(ParametersUtil.class);
    private static final String PLACEHOLDER = "** NOT SPECIFIED **";
    private static final SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private static final SimpleDateFormat simpleTimeFormat = new SimpleDateFormat("HH:mm:ss");
    private static final SimpleDateFormat simpleDateTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
    private static final DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private static final DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

    public static void setCurrentDateTime(Property property, Object instance) {
        Field field = ParametersUtil.getFieldFromInstance(instance, property.name);
        try {
            Object value = field.get(instance);
            if (null != value) {
                return;
            }
            switch (property.className) {
                case "java.util.Date": {
                    field.set(instance, new java.util.Date(System.currentTimeMillis()));
                    break;
                }
                case "java.sql.Date": {
                    field.set(instance, new Date(System.currentTimeMillis()));
                    break;
                }
                case "java.sql.Timestamp": {
                    field.set(instance, new Timestamp(System.currentTimeMillis()));
                    break;
                }
                case "java.util.Calendar": {
                    field.set(instance, Calendar.getInstance());
                    break;
                }
                case "java.time.LocalDate": {
                    field.set(instance, LocalDate.now());
                    break;
                }
                case "java.time.LocalDateTime": {
                    field.set(instance, LocalDateTime.now());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("\u4e0d\u652f\u6301\u8be5\u65e5\u671f\u7c7b\u578b,\u76ee\u524d\u652f\u6301\u7684\u7c7b\u578b\u4e3aDate,Calendar,LocalDate,LocalDateTime!\u5f53\u524d\u7c7b\u578b:" + property.className);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("\u8bbe\u7f6e\u5f53\u524d\u65f6\u95f4\u5f02\u5e38", e);
        }
    }

    public static String getFormatSQL(String sql, Collection parameters) {
        if (null == parameters || parameters.isEmpty()) {
            return sql;
        }
        int parameterCount = 0;
        for (int i = 0; i < sql.length(); ++i) {
            if (sql.charAt(i) != '?') continue;
            ++parameterCount;
        }
        if (parameterCount != parameters.size()) {
            logger.warn("\u53c2\u6570\u4e2a\u6570\u4e0d\u5339\u914d!\u9884\u671f\u53c2\u6570\u4e2a\u6570:{},\u5b9e\u9645\u53c2\u6570\u4e2a\u6570:{},\r\n\u8bed\u53e5:{}\r\n\u53c2\u6570\u5217\u8868:{}", new Object[]{parameterCount, parameters.size(), sql, parameters});
            throw new IllegalArgumentException("\u53c2\u6570\u4e2a\u6570\u4e0d\u5339\u914d!\u9884\u671f\u4e2a\u6570:" + parameterCount + ",\u5b9e\u9645\u4e2a\u6570:" + parameters.size());
        }
        StringBuilder sqlBuilder = new StringBuilder(sql.replace("?", PLACEHOLDER));
        for (Object parameter : parameters) {
            String parameterPlaceHolder = ParametersUtil.getParameterPlaceHolder(parameter);
            int indexOf = sqlBuilder.indexOf(PLACEHOLDER);
            sqlBuilder.replace(indexOf, indexOf + PLACEHOLDER.length(), parameterPlaceHolder);
        }
        String formatSQL = sqlBuilder.toString();
        return formatSQL;
    }

    public static Object getFieldValueFromInstance(Object instance, String name) {
        Field field = ParametersUtil.getFieldFromInstance(instance, name);
        try {
            Object value = field.get(instance);
            return value;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("\u83b7\u53d6\u5b9e\u4f8b\u5b57\u6bb5\u503c\u5931\u8d25", e);
        }
    }

    public static Field getFieldFromInstance(Object instance, String name) {
        Field field = null;
        block0: for (Class<?> tempClass = instance.getClass(); null == field && null != tempClass; tempClass = tempClass.getSuperclass()) {
            Field[] fields;
            for (Field field1 : fields = tempClass.getDeclaredFields()) {
                if (!field1.getName().equals(name)) continue;
                field = field1;
                continue block0;
            }
        }
        if (null == field) {
            throw new IllegalArgumentException("\u5b57\u6bb5\u4e0d\u5b58\u5728!\u5b57\u6bb5\u540d:" + name + ",\u7c7b\u540d:" + instance.getClass().getName());
        }
        field.setAccessible(true);
        return field;
    }

    private static String getParameterPlaceHolder(Object parameter) {
        if (null == parameter) {
            return "null";
        }
        String parameterSQL = parameter.toString();
        switch (parameter.getClass().getName()) {
            case "boolean": {
                boolean value = (Boolean)parameter;
                parameterSQL = value ? "1" : "0";
                break;
            }
            case "java.lang.String": 
            case "com.alibaba.fastjson.JSONObject": 
            case "com.alibaba.fastjson.JSONArray": {
                parameterSQL = "'" + parameter.toString() + "'";
                break;
            }
            case "java.util.Date": {
                java.util.Date date = (java.util.Date)parameter;
                parameterSQL = "'" + simpleDateFormat.format(date) + "'";
                break;
            }
            case "java.sql.Date": {
                Date date = (Date)parameter;
                parameterSQL = "'" + simpleDateFormat.format(date) + "'";
                break;
            }
            case "java.sql.Time": {
                Time time = (Time)parameter;
                parameterSQL = "'" + simpleTimeFormat.format(time) + "'";
                break;
            }
            case "java.sql.Timestamp": {
                Timestamp timestamp = (Timestamp)parameter;
                parameterSQL = "'" + simpleDateTimeFormat.format(timestamp) + "'";
                break;
            }
            case "java.time.LocalDate": {
                LocalDate localDate = (LocalDate)parameter;
                parameterSQL = "'" + localDate.format(dateFormatter) + "'";
                break;
            }
            case "java.time.LocalDateTime": {
                LocalDateTime localDateTime = (LocalDateTime)parameter;
                parameterSQL = "'" + localDateTime.format(dateTimeFormatter) + "'";
            }
        }
        return parameterSQL;
    }
}

