package cn.schoolwow.quick.starter.ams.controller.mall;

import cn.schoolwow.ams.listener.AMSListener;
import cn.schoolwow.ams.util.AMSUtil;
import cn.schoolwow.quick.starter.domain.ams.DiagnoseFlow;
import cn.schoolwow.quick.starter.domain.ams.DiagnoseRequest;
import cn.schoolwow.quick.starter.entity.log.FlowLog;
import cn.schoolwow.quick.starter.util.CommonUtil;
import cn.schoolwow.quickdao.dao.DAO;
import cn.schoolwow.quickflow.QuickFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@RestController
@RequestMapping("/ams/api")
public class DiagnoseController {
    @Resource
    private DAO starterDAO;

    @Resource
    private QuickFlow quickFlow;

    @Autowired(required = false)
    private List<DiagnoseFlow> diagnoseFlowList;

    @Resource
    private AMSListener starterAMSListener;

    @RequestMapping("/{projectName}/clazz/diagnose/list")
    public JSONObject list(
            @PathVariable("projectName") String projectName,
            @RequestParam Map<String,Object> requestParam
    ){
        if(!starterAMSListener.projectName().equals(projectName)){
            throw new IllegalArgumentException("项目名不匹配!");
        }

        JSONObject request = new JSONObject(requestParam);
        DiagnoseRequest diagnoseRequest = request.toJavaObject(DiagnoseRequest.class);

        Validate.notEmpty(diagnoseRequest.type, "流程类型不能为空");

        if(null==diagnoseFlowList||diagnoseFlowList.isEmpty()){
            throw new IllegalArgumentException("不支持的流程类型!流程类型:"+diagnoseRequest.type);
        }
        DiagnoseFlow selectedDiagnoseFlow = null;
        for(DiagnoseFlow diagnoseFlow:diagnoseFlowList){
            if(diagnoseFlow.name().equalsIgnoreCase(diagnoseRequest.type)){
                selectedDiagnoseFlow = diagnoseFlow;
                break;
            }
        }
        if(null==selectedDiagnoseFlow){
            throw new IllegalArgumentException("不支持的流程类型!流程类型:"+diagnoseRequest.type);
        }

        long startTime = System.currentTimeMillis();
        request.remove("type");
        request.remove("value");
        request.remove("page");
        request.remove("pageSize");
        starterDAO.recordSqlLog(false);
        FlowContext flowContext = quickFlow.startFlow(selectedDiagnoseFlow)
                .putTemporaryData("diagnoseRequest", diagnoseRequest)
                .putTemporaryData(request)
                .execute();
        starterDAO.recordSqlLog(true);
        JSONArray list = new JSONArray();
        FlowLog flowLog = CommonUtil.flowContext2FlowLog(flowContext);
        flowLog.setContextData(JSON.parseObject(JSON.toJSONString(flowContext.getData())));
        flowLog.setConsumeTime(System.currentTimeMillis()-startTime);
        flowLog.setCreatedAt(LocalDateTime.now());
        flowLog.setUpdatedAt(LocalDateTime.now());
        list.add(flowLog);
        return AMSUtil.getAMSList(list);
    }

    @RequestMapping("/placeholder")
    public Map<String,String> placeholder(
    ){
        Map<String,String> placeHolderMap = new HashMap<>();
        if(null!=diagnoseFlowList){
            for(DiagnoseFlow diagnoseFlow:diagnoseFlowList){
                if(StringUtils.isNotBlank(diagnoseFlow.placeholder())){
                    placeHolderMap.put(diagnoseFlow.name(), diagnoseFlow.placeholder());
                }
            }
        }
        return placeHolderMap;
    }
}
