package cn.schoolwow.quick.starter.ams.listener.clazz;

import cn.schoolwow.ams.domain.listener.clazz.AMSClazzListener;
import cn.schoolwow.ams.domain.listener.clazz.ListClazzListener;
import cn.schoolwow.ams.listener.AMSClazzListenerAware;
import cn.schoolwow.ams.listener.AMSListener;
import cn.schoolwow.ams.util.AMSUtil;
import cn.schoolwow.data.thread.QuickDataThread;
import cn.schoolwow.data.thread.domain.DataThreadProgress;
import cn.schoolwow.quick.starter.domain.ams.AMSDataThreadProgress;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

@Service
public class AMSDataThreadProgressClassListener implements AMSClazzListenerAware {
    @Resource
    private QuickDataThread quickDataThread;

    @Resource
    private AMSListener starterAMSListener;

    @Override
    public List<AMSClazzListener> getAMSClazzListenerList() {
        return Arrays.asList(new AMSClazzListener()
                .projectName(starterAMSListener.projectName())
                .className("AMSDataThreadProgress")
                .list(new ListClazzListener() {
                    @Override
                    public JSONObject list(Map<String, Object> amsListConditionMap) {
                        JSONObject amsListCondition = JSON.parseObject(JSON.toJSONString(amsListConditionMap));
                        List<DataThreadProgress> dataThreadProgressList = quickDataThread.getDataThreadProgressList();
                        List<AMSDataThreadProgress> amsDataThreadProgressList = JSON.parseArray(JSON.toJSONString(dataThreadProgressList)).toJavaList(AMSDataThreadProgress.class);
                        return AMSUtil.getAMSList(amsDataThreadProgressList);
                    }
                })
        );
    }
}
