package cn.schoolwow.quick.starter.ams.listener.clazz.database;

import cn.schoolwow.ams.domain.listener.clazz.AMSClazzListener;
import cn.schoolwow.ams.domain.listener.clazz.ListClazzListener;
import cn.schoolwow.ams.listener.AMSClazzListenerAware;
import cn.schoolwow.ams.listener.AMSListener;
import cn.schoolwow.ams.util.AMSUtil;
import cn.schoolwow.quick.starter.domain.ams.database.DatabaseIndexField;
import cn.schoolwow.quickdao.dao.DAO;
import cn.schoolwow.quickdao.domain.external.Entity;
import cn.schoolwow.quickdao.domain.external.IndexField;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

@Service
public class DatabaseIndexFieldClazzListener implements AMSClazzListenerAware {
    @Resource
    private DAO starterDAO;

    @Resource
    private AMSListener starterAMSListener;

    @Override
    public List<AMSClazzListener> getAMSClazzListenerList() {
        return Arrays.asList(new AMSClazzListener()
                .projectName(starterAMSListener.projectName())
                .className("DatabaseIndexField")
                .list(new ListClazzListener() {
                    @Override
                    public JSONObject list(Map<String, Object> amsListConditionMap) {
                        JSONObject amsCondition = new JSONObject(amsListConditionMap);
                        DatabaseIndexField databaseIndexFieldCondition = amsCondition.toJavaObject(DatabaseIndexField.class);

                        List<Entity> entityList = starterDAO.getDatabaseEntityList();
                        List<DatabaseIndexField> databaseIndexFieldList = new ArrayList<>();
                        for(Entity entity:entityList){
                            for(IndexField indexField:entity.indexFieldList){
                                int indexType = -1;
                                switch (indexField.indexType){
                                    case NORMAL:indexType = 0;break;
                                    case UNIQUE:indexType = 1;break;
                                    case FULLTEXT:indexType = 2;break;
                                    default:{
                                        throw new IllegalArgumentException("不支持的索引类型!索引类型:"+indexField.indexType.name());
                                    }
                                }

                                if(null!=databaseIndexFieldCondition){
                                    if(StringUtils.isNotBlank(databaseIndexFieldCondition.tableName)&&!indexField.tableName.matches(databaseIndexFieldCondition.tableName)){
                                        continue;
                                    }
                                    if(null!=databaseIndexFieldCondition.indexType&&indexType!=databaseIndexFieldCondition.indexType){
                                        continue;
                                    }
                                    if(StringUtils.isNotBlank(databaseIndexFieldCondition.indexName)&&!indexField.indexName.matches(databaseIndexFieldCondition.indexName)){
                                        continue;
                                    }
                                    if(StringUtils.isNotBlank(databaseIndexFieldCondition.using)&&!indexField.using.matches(databaseIndexFieldCondition.using)){
                                        continue;
                                    }
                                    if(StringUtils.isNotBlank(databaseIndexFieldCondition.comment)&&!indexField.comment.matches(databaseIndexFieldCondition.comment)){
                                        continue;
                                    }
                                    if(StringUtils.isNotBlank(databaseIndexFieldCondition.columns)&&!indexField.columns.contains(databaseIndexFieldCondition.columns)){
                                        continue;
                                    }
                                }
                                DatabaseIndexField databaseIndexField = new DatabaseIndexField();
                                databaseIndexField.tableName = indexField.tableName;
                                databaseIndexField.indexName = indexField.indexName;
                                databaseIndexField.indexType = indexType;
                                databaseIndexField.using = indexField.using;
                                databaseIndexField.columns = indexField.columns.toString();
                                databaseIndexField.comment = indexField.comment;
                                databaseIndexFieldList.add(databaseIndexField);
                            }
                        }
                        return AMSUtil.getAMSList(databaseIndexFieldList);
                    }
                })
        );
    }
}
