package cn.schoolwow.quick.starter.ams.listener.clazz.database;

import cn.schoolwow.ams.domain.listener.clazz.AMSClazzListener;
import cn.schoolwow.ams.domain.listener.clazz.ListClazzListener;
import cn.schoolwow.ams.listener.AMSClazzListenerAware;
import cn.schoolwow.ams.listener.AMSListener;
import cn.schoolwow.ams.util.AMSUtil;
import cn.schoolwow.quick.starter.domain.ams.database.DatabaseProperty;
import cn.schoolwow.quickdao.dao.DAO;
import cn.schoolwow.quickdao.domain.external.Entity;
import cn.schoolwow.quickdao.domain.external.Property;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

@Service
public class DatabasePropertyClazzListener implements AMSClazzListenerAware {
    @Resource
    private DAO starterDAO;

    @Resource
    private AMSListener starterAMSListener;

    @Override
    public List<AMSClazzListener> getAMSClazzListenerList() {
        return Arrays.asList(new AMSClazzListener()
                .projectName(starterAMSListener.projectName())
                .className("DatabaseProperty")
                .list(new ListClazzListener() {
                    @Override
                    public JSONObject list(Map<String, Object> amsListConditionMap) {
                        JSONObject amsCondition = new JSONObject(amsListConditionMap);
                        DatabaseProperty databasePropertyCondition = amsCondition.toJavaObject(DatabaseProperty.class);

                        List<Entity> entityList = starterDAO.getDatabaseEntityList();
                        List<DatabaseProperty> databasePropertyList = new ArrayList<>();
                        for(Entity entity:entityList){
                            if(null!=databasePropertyCondition&&StringUtils.isNotBlank(databasePropertyCondition.tableName)&&!entity.tableName.matches(databasePropertyCondition.tableName)){
                                continue;
                            }
                            for(Property property:entity.properties){
                                if(null!=databasePropertyCondition){
                                    if(StringUtils.isNotBlank(databasePropertyCondition.columnName)&&!property.column.matches(databasePropertyCondition.columnName)){
                                        continue;
                                    }
                                    if(StringUtils.isNotBlank(databasePropertyCondition.columnType)&&!property.columnType.matches(databasePropertyCondition.columnType)){
                                        continue;
                                    }
                                    if(StringUtils.isNotBlank(databasePropertyCondition.comment)&&!property.comment.matches(databasePropertyCondition.comment)){
                                        continue;
                                    }
                                }

                                DatabaseProperty databaseProperty = new DatabaseProperty();
                                databaseProperty.tableName = entity.tableName;
                                databaseProperty.columnName = property.column;
                                databaseProperty.columnType = property.columnType;
                                databaseProperty.comment = property.comment;
                                databaseProperty.notNull = property.notNull;
                                databaseProperty.check = property.check;
                                databaseProperty.defaultValue = property.defaultValue;
                                databasePropertyList.add(databaseProperty);
                            }
                        }
                        return AMSUtil.getAMSList(databasePropertyList);
                    }
                })
        );
    }
}
