package cn.schoolwow.quick.starter.ams.listener.copy;

import cn.schoolwow.ams.listener.AMSListener;
import cn.schoolwow.ams.listener.CopyFieldOperation;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

@Service
public class LogCopyFieldOperation implements CopyFieldOperation {
    @Resource
    private AMSListener starterAMSListener;
    
    @Override
    public String[] copyFieldArray() {
        List<String> copyFieldArray = new ArrayList<>();
        //http日志
        copyFieldArray.add(starterAMSListener.projectName()+"|starter|log@http_request_log|requestHeaders|复制请求头部");
        copyFieldArray.add(starterAMSListener.projectName()+"|starter|log@http_request_log|responseHeaders|复制响应头部");
        copyFieldArray.add(starterAMSListener.projectName()+"|starter|log@http_request_log|method,url,requestBody,responseBody|复制请求响应");
        copyFieldArray.add(starterAMSListener.projectName()+"|starter|log@http_request_log|exception|复制异常");

        //流程日志
        copyFieldArray.add(starterAMSListener.projectName()+"|starter|log@flow_log|flowTrace|复制流程日志");
        copyFieldArray.add(starterAMSListener.projectName()+"|starter|log@flow_log|requestData,contextData|复制流程数据");
        copyFieldArray.add(starterAMSListener.projectName()+"|starter|log@flow_log|exception|复制异常");

        //sql日志
        copyFieldArray.add(starterAMSListener.projectName()+"|starter|quickdao_sql_log|statement,parameters|复制语句");
        copyFieldArray.add(starterAMSListener.projectName()+"|starter|quickdao_sql_log|formatStatement|复制格式化语句");
        copyFieldArray.add(starterAMSListener.projectName()+"|starter|quickdao_sql_log|exception|复制异常");

        //定时任务日志
        copyFieldArray.add(starterAMSListener.projectName()+"|starter|log@task_log|flowTrace|复制任务日志");
        copyFieldArray.add(starterAMSListener.projectName()+"|starter|log@task_log|requestData,contextData|复制任务数据");
        copyFieldArray.add(starterAMSListener.projectName()+"|starter|log@task_log|exception|复制异常");

        //流程配置
        copyFieldArray.add(starterAMSListener.projectName()+"|starter|sys@project_flow_config|requestData|复制配置数据");

        //诊断日志
        copyFieldArray.add(starterAMSListener.projectName()+"|clazz|diagnose|flowTrace|复制流程日志");
        copyFieldArray.add(starterAMSListener.projectName()+"|clazz|diagnose|requestData,contextData|复制流程数据");
        copyFieldArray.add(starterAMSListener.projectName()+"|clazz|diagnose|exception|复制异常");
        
        return copyFieldArray.toArray(new String[0]);
    }
}
