package cn.schoolwow.quick.starter.ams.listener.list;

import cn.schoolwow.ams.domain.listener.list.AMSListBlock;
import cn.schoolwow.ams.listener.AMSListBlockAware;
import cn.schoolwow.ams.listener.AMSListener;
import cn.schoolwow.quickdao.dao.DAO;
import cn.schoolwow.quickdao.domain.external.Entity;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

@Service
public class StarterDatabaseListBlock implements AMSListBlockAware {
    @Resource
    private DAO starterDAO;

    @Resource
    private AMSListener starterAMSListener;

    @Override
    public List<AMSListBlock> getListBlockList() {
        List<AMSListBlock> amsListBlockList = new ArrayList<>();

        List<Entity> entityList = starterDAO.getDatabaseEntityList();
        for(int i=0;i<entityList.size();i++){
            Entity entity = entityList.get(i);
            //排除表
            if (entity.tableName.equalsIgnoreCase("quickdao_database_upgrade")) {
                continue;
            }
            amsListBlockList.add(new AMSListBlock().projectName(starterAMSListener.projectName()).databaseBlock("starter", entity));
        }
        return amsListBlockList;
    }
}
