package cn.schoolwow.quick.starter.ams.listener.operation.log;

import cn.schoolwow.ams.domain.listener.operation.AMSOperation;
import cn.schoolwow.ams.domain.listener.operation.AMSOperationPosition;
import cn.schoolwow.ams.domain.listener.operation.HandleOperation;
import cn.schoolwow.ams.listener.AMSListener;
import cn.schoolwow.ams.listener.AMSOperationAware;
import cn.schoolwow.quick.starter.flow.ams.ExecuteFlow;
import cn.schoolwow.quickflow.QuickFlow;
import com.alibaba.fastjson.JSONObject;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Arrays;
import java.util.List;

@Service
public class ExecuteFlowOperation implements AMSOperationAware {
    @Resource
    private AMSListener starterAMSListener;

    @Resource
    private QuickFlow quickFlow;

    @Resource
    private ApplicationContext applicationContext;

    @Override
    public List<AMSOperation> getAMSOperationList() {
        return Arrays.asList(new AMSOperation()
                .projectName(starterAMSListener.projectName())
                .daoName("starter")
                .tableName("log@flow_log")
                .methodName("executeFlow")
                .position(AMSOperationPosition.MultipleSelect)
                .name("执行流程")
                .fieldNameList("name", "requestData", "flowNameList")
                .handle(new HandleOperation() {
                    @Override
                    public JSONObject handle(String methodName, JSONObject data) throws Exception {
                        quickFlow.startFlow(applicationContext.getBean(ExecuteFlow.class))
                                .executeGlobalTryCatchFinally(false)
                                .putCurrentCompositeFlowData("data", data)
                                .execute();
                        return null;
                    }
                })
        );
    }

}
