package cn.schoolwow.quick.starter.ams.listener.operation.log;

import cn.schoolwow.ams.domain.listener.operation.AMSOperation;
import cn.schoolwow.ams.domain.listener.operation.HandleOperation;
import cn.schoolwow.ams.listener.AMSListener;
import cn.schoolwow.ams.listener.AMSOperationAware;
import cn.schoolwow.quick.starter.entity.log.HttpRequestLog;
import cn.schoolwow.quick.starter.util.CommonUtil;
import cn.schoolwow.quickdao.dao.DAO;
import cn.schoolwow.quickhttp.QuickHttp;
import cn.schoolwow.quickhttp.request.Request;
import cn.schoolwow.quickhttp.response.Response;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.*;

@Service
public class ExecuteHttpRequestOperation implements AMSOperationAware {
    @Resource
    private DAO starterDAO;

    @Resource
    private AMSListener starterAMSListener;

    @Override
    public List<AMSOperation> getAMSOperationList() {
        return Arrays.asList(new AMSOperation()
                .projectName(starterAMSListener.projectName())
                .daoName("starter")
                .tableName("log@http_request_log")
                .methodName("executeHttpRequest")
                .name("执行HTTP请求")
                .fieldNameList(new String[0])
                .handle(new HandleOperation() {
                    @Override
                    public JSONObject handle(String methodName, JSONObject data) throws Exception {
                        HttpRequestLog executeHttpRequestLog = data.toJavaObject(HttpRequestLog.class);
                        JSONObject requestHeaders = JSON.parseObject(executeHttpRequestLog.getRequestHeaders());

                        Map<String, List<String>> requestHeaderMap = new HashMap<>();
                        Set<String> keySet = requestHeaders.keySet();
                        for (String key : keySet) {
                            requestHeaderMap.put(key, requestHeaders.getJSONArray(key).toJavaList(String.class));
                        }
                        Request request = QuickHttp.connect(executeHttpRequestLog.getUrl())
                                .method(executeHttpRequestLog.getMethod())
                                .headers(requestHeaderMap);
                        if (StringUtils.isNoneBlank(executeHttpRequestLog.getRequestBody())) {
                            request.requestBody(executeHttpRequestLog.getRequestBody());
                        }
                        long startTime = System.currentTimeMillis();

                        Response response = null;
                        Exception ex = null;
                        try {
                            response = request.execute();
                        } catch (Exception e) {
                            ex = e;
                            throw e;
                        } finally {
                            HttpRequestLog httpRequestLog = CommonUtil.getHttpRequestLog(request.getRequestMeta(), response, ex, executeHttpRequestLog.getSource(), startTime);
                            starterDAO.insert(httpRequestLog);
                        }
                        return null;
                    }
                })
        );
    }
}