package cn.schoolwow.quick.starter.ams.listener.operation.log;

import cn.schoolwow.ams.domain.listener.operation.AMSOperation;
import cn.schoolwow.ams.domain.listener.operation.HandleOperation;
import cn.schoolwow.ams.listener.AMSListener;
import cn.schoolwow.ams.listener.AMSOperationAware;
import cn.schoolwow.quickdao.dao.DAO;
import cn.schoolwow.quickdao.domain.external.entity.SqlLog;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.Validate;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Arrays;
import java.util.List;

@Service
public class ExecuteSQLOperation implements AMSOperationAware {
    @Resource
    private DAO starterDAO;

    @Resource
    private AMSListener starterAMSListener;

    @Override
    public List<AMSOperation> getAMSOperationList() {
        return Arrays.asList(new AMSOperation()
                .projectName(starterAMSListener.projectName())
                .daoName("starter")
                .tableName("quickdao_sql_log")
                .methodName("executeStatement")
                .name("执行SQL")
                .fieldNameList("id")
                .handle(new HandleOperation() {
                    @Override
                    public JSONObject handle(String methodName, JSONObject data) throws Exception {
                        Long id = data.getLong("id");

                        SqlLog sqlLog = starterDAO.fetch(SqlLog.class, id);
                        Validate.notNull(sqlLog, "SQL日志查询为空");

                        switch (sqlLog.getType()){
                            case 0:{starterDAO.rawSelect(sqlLog.getFormatStatement());}break;
                            case 1:{starterDAO.rawUpdate(sqlLog.getFormatStatement());}break;
                            default:{
                                throw new IllegalArgumentException("不支持的数据库语句类型!类型:"+sqlLog.getType());
                            }
                        }
                        return null;
                    }
                })
        );
    }
}