package cn.schoolwow.quick.starter.ams.listener.operation.log;

import cn.schoolwow.ams.domain.listener.operation.AMSOperation;
import cn.schoolwow.ams.domain.listener.operation.HandleOperation;
import cn.schoolwow.ams.listener.AMSListener;
import cn.schoolwow.ams.listener.AMSOperationAware;
import cn.schoolwow.quick.starter.config.flow.StarterMallFlowMappingHandler;
import cn.schoolwow.quickflow.QuickFlow;
import cn.schoolwow.quickflow.flow.CompositeBusinessFlow;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Arrays;
import java.util.List;

@Service
public class ExecuteTaskOperation implements AMSOperationAware {
    @Resource
    private QuickFlow quickFlow;

    @Resource
    private StarterMallFlowMappingHandler mallFlowMappingHandler;

    @Resource
    private AMSListener starterAMSListener;

    @Override
    public List<AMSOperation> getAMSOperationList() {
        return Arrays.asList(new AMSOperation()
                .projectName(starterAMSListener.projectName())
                .daoName("starter")
                .tableName("log@task_log")
                .methodName("executeTask")
                .name("执行定时任务")
                .fieldNameList("name")
                .handle(new HandleOperation() {
                    @Override
                    public JSONObject handle(String methodName, JSONObject data) throws Exception {
                        String name = data.getString("name");

                        CompositeBusinessFlow compositeBusinessFlow = mallFlowMappingHandler.getCompositeBusinessFlow(name);
                        quickFlow.executeFlow(compositeBusinessFlow);
                        return null;
                    }
                })
        );
    }
}
