package cn.schoolwow.quick.starter.ams.listener.operation.log;

import cn.schoolwow.ams.domain.listener.operation.AMSOperation;
import cn.schoolwow.ams.domain.listener.operation.AMSOperationPosition;
import cn.schoolwow.ams.domain.listener.operation.HandleOperation;
import cn.schoolwow.ams.listener.AMSListener;
import cn.schoolwow.ams.listener.AMSOperationAware;
import cn.schoolwow.quick.starter.flow.ams.ExecuteFlow;
import cn.schoolwow.quickflow.QuickFlow;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Arrays;
import java.util.List;

@Service
public class MunualExecuteFlowOperation implements AMSOperationAware {
    @Resource
    private QuickFlow quickFlow;

    @Resource
    private AMSListener starterAMSListener;

    @Resource
    private ApplicationContext applicationContext;

    @Override
    public List<AMSOperation> getAMSOperationList() {
        return Arrays.asList(new AMSOperation()
                .projectName(starterAMSListener.projectName())
                .daoName("starter")
                .tableName("log@flow_log")
                .methodName("manualExecuteFlow")
                .position(AMSOperationPosition.None)
                .name("手动执行流程")
                .fieldNameList("name", "requestData", "flowNameList")
                .handle(new HandleOperation() {
                    @Override
                    public JSONObject handle(String methodName, JSONObject data) throws Exception {
                        JSONObject o = new JSONObject();

                        JSONArray list = new JSONArray();
                        list.add(data);

                        o.put("list", list);

                        quickFlow.startFlow(applicationContext.getBean(ExecuteFlow.class))
                                .putCurrentCompositeFlowData("data", o)
                                .execute();
                        return null;
                    }
                })
        );
    }

}
