package cn.schoolwow.quick.starter.ams.listener.operation.sys;

import cn.schoolwow.ams.domain.listener.operation.AMSOperation;
import cn.schoolwow.ams.domain.listener.operation.AMSOperationPosition;
import cn.schoolwow.ams.domain.listener.operation.HandleOperation;
import cn.schoolwow.ams.listener.AMSListener;
import cn.schoolwow.ams.listener.AMSOperationAware;
import cn.schoolwow.quick.starter.entity.log.FlowLog;
import cn.schoolwow.quick.starter.entity.sys.FlowRecord;
import cn.schoolwow.quickdao.dao.DAO;
import cn.schoolwow.quickdao.dao.dql.condition.Condition;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@Service
public class AddTestFlowLogOperation implements AMSOperationAware {
    @Resource
    private DAO starterDAO;

    @Resource
    private AMSListener starterAMSListener;

    @Override
    public List<AMSOperation> getAMSOperationList() {
        return Arrays.asList(new AMSOperation()
                .projectName(starterAMSListener.projectName())
                .daoName("starter")
                .tableName("log@flow_log")
                .methodName("addTestFlowLog")
                .position(AMSOperationPosition.RightTop)
                .name("添加测试用例")
                .handle(new HandleOperation() {
                    @Override
                    public JSONObject handle(String methodName, JSONObject data) throws Exception {
                        Condition subCondition = starterDAO.query(FlowLog.class)
                                .addColumn("name")
                                .addColumn("request_data")
                                .addColumn("flow_name_list")
                                .addColumn("ROW_NUMBER() OVER (PARTITION BY name ORDER BY created_at DESC) AS rn")
                                .orderByDesc("created_at");
                        JSONArray array = starterDAO.query(subCondition)
                                .addColumn("name")
                                .addColumn("request_data")
                                .addColumn("flow_name_list")
                                .addRawQuery("rn = 1")
                                .execute()
                                .getArray();

                        List<FlowRecord> flowRecordList = new ArrayList<>();
                        for(int i=0;i<array.size();i++){
                            JSONObject o = array.getJSONObject(i);
                            FlowRecord flowRecord = new FlowRecord();
                            flowRecord.setCategoryName("测试流程");
                            flowRecord.setName(o.getString("name"));
                            flowRecord.setRequestData(o.getJSONObject("request_data"));
                            flowRecord.setFlowNameList(o.getString("flow_name_list"));
                            flowRecordList.add(flowRecord);
                        }
                        int effect = starterDAO.insertIgnore(flowRecordList);
                        JSONObject result = new JSONObject();
                        result.put("effect", effect);
                        result.put("expect", flowRecordList.size());

                        long count = starterDAO.query(FlowRecord.class)
                                .addQuery("categoryName", "测试流程")
                                .execute()
                                .count();
                        result.put("count", count);
                        return result;
                    }
                })
        );
    }
}
