package cn.schoolwow.quick.starter.ams.listener.operation.sys;

import cn.schoolwow.ams.domain.listener.operation.AMSOperation;
import cn.schoolwow.ams.domain.listener.operation.AMSOperationPosition;
import cn.schoolwow.ams.domain.listener.operation.HandleOperation;
import cn.schoolwow.ams.listener.AMSListener;
import cn.schoolwow.ams.listener.AMSOperationAware;
import cn.schoolwow.quick.starter.entity.sys.FlowRecord;
import cn.schoolwow.quick.starter.flow.ams.ExecuteFlow;
import cn.schoolwow.quickdao.dao.DAO;
import cn.schoolwow.quickflow.QuickFlow;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Arrays;
import java.util.List;

@Service
public class ExecuteFlowByCategoryNameOperation implements AMSOperationAware {
    @Resource
    private DAO starterDAO;

    @Resource
    private AMSListener starterAMSListener;

    @Resource
    private QuickFlow quickFlow;

    @Resource
    private ApplicationContext applicationContext;

    @Override
    public List<AMSOperation> getAMSOperationList() {
        return Arrays.asList(new AMSOperation()
                .projectName(starterAMSListener.projectName())
                .daoName("starter")
                .tableName("sys@flow_record")
                .methodName("executeFlowByCategoryName")
                .position(AMSOperationPosition.RightTop)
                .name("根据分类执行流程")
                .searchFieldNameList("categoryName")
                .handle(new HandleOperation() {
                    @Override
                    public JSONObject handle(String methodName, JSONObject data) throws Exception {
                        String categoryName = data.getJSONObject("searchs").getString("categoryName");

                        List<FlowRecord> flowRecordList = starterDAO.query(FlowRecord.class)
                                .addQuery("categoryName", categoryName)
                                .execute()
                                .getList();

                        JSONArray flowList = new JSONArray();
                        for(FlowRecord flowRecord:flowRecordList){
                            JSONObject o = new JSONObject();
                            o.put("name", flowRecord.getName());
                            o.put("flowNameList", flowRecord.getFlowNameList());
                            o.put("requestData", flowRecord.getRequestData());
                            flowList.add(o);
                        }
                        data.put("list", flowList);
                        quickFlow.startFlow(applicationContext.getBean(ExecuteFlow.class))
                                .putCurrentCompositeFlowData("data", data)
                                .execute();
                        return null;
                    }
                })
        );
    }
}
