package cn.schoolwow.quick.starter.ams.listener.operation.sys;

import cn.schoolwow.ams.domain.listener.operation.AMSOperation;
import cn.schoolwow.ams.domain.listener.operation.AMSOperationPosition;
import cn.schoolwow.ams.domain.listener.operation.HandleOperation;
import cn.schoolwow.ams.listener.AMSListener;
import cn.schoolwow.ams.listener.AMSOperationAware;
import cn.schoolwow.data.thread.QuickDataThread;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Arrays;
import java.util.List;

@Service
public class InterruptDataThreadProgressOperation implements AMSOperationAware {
    @Resource
    private QuickDataThread quickDataThread;

    @Resource
    private AMSListener starterAMSListener;

    @Override
    public List<AMSOperation> getAMSOperationList() {
        return Arrays.asList(new AMSOperation()
                .projectName(starterAMSListener.projectName())
                .daoName("clazz")
                .tableName("AMSDataThreadProgress")
                .methodName("interruptAMSDataThreadProgress")
                .position(AMSOperationPosition.MultipleSelect)
                .name("中断")
                .fieldNameList("id")
                .handle(new HandleOperation() {
                    @Override
                    public JSONObject handle(String methodName, JSONObject data) throws Exception {
                        List<Long> idList = data.getJSONArray("idList").toJavaList(Long.class);

                        for(Long id:idList){
                            quickDataThread.interruptDataThread(id);
                        }
                        return null;
                    }
                })
        );
    }
}
