package cn.schoolwow.quick.starter.ams.listener.routerpush;

import cn.schoolwow.ams.domain.listener.routerpush.AMSRouterPush;
import cn.schoolwow.ams.listener.AMSListener;
import cn.schoolwow.ams.listener.AMSRouterPushAware;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Arrays;
import java.util.List;

@Service
public class FlowLogRouterPush implements AMSRouterPushAware {
    @Resource
    private AMSListener starterAMSListener;

    @Override
    public List<AMSRouterPush> getAMSRouterPushList() {
        return Arrays.asList(new AMSRouterPush()
                .projectName(starterAMSListener.projectName())
                .daoName("starter")
                .tableName("log@flow_log")
                .label("查看关联HTTP请求")
                .name("viewHttpLog")
                .path("/log/"+starterAMSListener.projectName()+"|starter|log@http_request_log")
                .queryFieldNameList("flowId")
        );
    }
}
