package cn.schoolwow.quick.starter.ams.listener.routerpush;

import cn.schoolwow.ams.domain.listener.routerpush.AMSRouterPush;
import cn.schoolwow.ams.listener.AMSListener;
import cn.schoolwow.ams.listener.AMSRouterPushAware;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Arrays;
import java.util.List;

@Service
public class HttpRequestLogRouterPush implements AMSRouterPushAware {
    @Resource
    private AMSListener starterAMSListener;

    @Override
    public List<AMSRouterPush> getAMSRouterPushList() {
        return Arrays.asList(new AMSRouterPush()
                .projectName(starterAMSListener.projectName())
                .daoName("starter")
                .tableName("log@http_request_log")
                .label("查看关联流程")
                .name("viewFlowLog")
                .path("/log/"+starterAMSListener+"|starter|log@flow_log")
                .queryFieldNameList("flowId")
        );
    }
}
