package cn.schoolwow.quick.starter.ams.listener.select;

import cn.schoolwow.ams.domain.listener.select.AMSRemoteSelect;
import cn.schoolwow.ams.domain.listener.select.GetRemoteOption;
import cn.schoolwow.ams.listener.AMSListener;
import cn.schoolwow.ams.listener.AMSRemoteSelectAware;
import cn.schoolwow.quick.starter.domain.ams.DiagnoseFlow;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;

import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import java.util.*;

public abstract class DiagnoseTypeRemoteSelectTemplate implements AMSRemoteSelectAware {
    @Autowired(required = false)
    private List<DiagnoseFlow> diagnoseFlowList;

    @Resource
    private AMSListener starterAMSListener;

    private JSONArray array = new JSONArray();

    @PostConstruct
    public void postConstruct(){
        String diagnosePackageName = getDiagnosePackageName();

        Map<String,List<BusinessFlow>> prefixBusinessMap = new HashMap<>();
        for(BusinessFlow businessFlow:diagnoseFlowList){
            String prefix = businessFlow.getClass().getPackage().getName().replace(diagnosePackageName,"");
            if(prefix.startsWith(".")){
                prefix = prefix.substring(1);
            }
            if(!prefixBusinessMap.containsKey(prefix)){
                prefixBusinessMap.put(prefix, new ArrayList<>());
            }
            prefixBusinessMap.get(prefix).add(businessFlow);
        }

        for(Map.Entry<String,List<BusinessFlow>> entry:prefixBusinessMap.entrySet()){
            JSONArray options = new JSONArray();
            for(BusinessFlow businessFlow:entry.getValue()){
                JSONObject option = new JSONObject();
                option.put("label", businessFlow.name());
                option.put("value", businessFlow.name());
                options.add(option);
            }
            if(entry.getKey().isEmpty()){
                array.addAll(options);
            }else{
                JSONObject compositeOption = new JSONObject();
                compositeOption.put("label", entry.getKey());
                compositeOption.put("options", options);
                array.add(compositeOption);
            }
        }
    }

    @Override
    public List<AMSRemoteSelect> getAMSRemoteSelectList() {
        return Arrays.asList(new AMSRemoteSelect()
                .uniqueKeyFieldList(starterAMSListener.projectName()+"|clazz|diagnose|type|诊断类型")
                .type("diagnoseType")
                .setRemoteOption(new GetRemoteOption() {
                    @Override
                    public JSONArray getRemoteOption(Map<String, String> amsRemoteSelectMap) {
                        return array;
                    }
                })
        );
    }

    /**返回诊断流程包名*/
    protected abstract String getDiagnosePackageName();
}
