package cn.schoolwow.quick.starter.ams.listener.select;

import cn.schoolwow.ams.domain.listener.select.AMSRemoteSelect;
import cn.schoolwow.ams.domain.listener.select.GetRemoteOption;
import cn.schoolwow.ams.listener.AMSListener;
import cn.schoolwow.ams.listener.AMSRemoteSelectAware;
import cn.schoolwow.quick.starter.entity.sys.FlowRecord;
import cn.schoolwow.quickdao.dao.DAO;
import cn.schoolwow.quickdao.dao.dql.condition.Condition;
import com.alibaba.fastjson.JSONArray;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

@Service
public class FlowRecordCategoryNameRemoteSelect implements AMSRemoteSelectAware {
    @Resource
    private DAO starterDAO;

    @Resource
    private AMSListener starterAMSListener;

    @Override
    public List<AMSRemoteSelect> getAMSRemoteSelectList() {
        return Arrays.asList(new AMSRemoteSelect()
                .uniqueKeyFieldList(starterAMSListener.projectName()+"|starter|sys@flow_record|categoryName|流程分类")
                .type("flowRecordCategoryName")
                .setRemoteOption(new GetRemoteOption() {
                    @Override
                    public JSONArray getRemoteOption(Map<String, String> amsRemoteSelectMap) {
                        Condition condition = starterDAO.query(FlowRecord.class)
                                .distinct()
                                .addColumn("categoryName label")
                                .addColumn("categoryName value")
                                .limit(0,10);
                        String name = amsRemoteSelectMap.get("name");
                        if(StringUtils.isNotBlank(name)){
                            condition.addLikeQuery("categoryName", "%"+name+"%");
                        }
                        JSONArray array = condition
                                .execute()
                                .getArray();
                        return array;
                    }
                })
        );
    }
}
