package cn.schoolwow.quick.starter.ams.listener.table.sys;

import cn.schoolwow.ams.domain.listener.table.*;
import cn.schoolwow.ams.listener.AMSListener;
import cn.schoolwow.ams.listener.AMSTableListenerAware;
import cn.schoolwow.quick.starter.entity.sys.ProjectFlowConfig;
import cn.schoolwow.quickdao.dao.dql.condition.Condition;
import cn.schoolwow.quickflow.QuickFlow;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Arrays;
import java.util.List;

@Service
public class ProjectFlowConfigTableListener implements AMSTableListenerAware {
    @Resource
    private QuickFlow quickFlow;

    @Resource
    private AMSListener starterAMSListener;

    @Override
    public List<AMSTableListener> getAMSTableListenerList() {
        return Arrays.asList(new AMSTableListener()
                .projectName(starterAMSListener.projectName())
                .daoName("starter")
                .tableName("sys@project_flow_config")
                .createTable(new CreateTable() {
                    @Override
                    public void beforeCreate(JSONObject createEntity) throws Exception {

                    }

                    @Override
                    public void afterCreate(JSONObject createEntity) throws Exception {
                        ProjectFlowConfig projectFlowConfig = createEntity.toJavaObject(ProjectFlowConfig.class);
                        quickFlow.getFlowConfigRequestData(projectFlowConfig.getName()).putAll(projectFlowConfig.getRequestData());
                    }
                })
                .editTable(new EditTable() {
                    @Override
                    public BeforeEditOption beforeEdit(JSONObject updateEntity) throws Exception {
                        BeforeEditOption beforeEditOption = new BeforeEditOption();
                        beforeEditOption.partColumnArray = new String[]{"requestData"};
                        return beforeEditOption;
                    }

                    @Override
                    public void afterEdit(BeforeEditOption beforeEditOption, JSONObject updateEntity) throws Exception {
                        ProjectFlowConfig projectFlowConfig = updateEntity.toJavaObject(ProjectFlowConfig.class);
                        quickFlow.getFlowConfigRequestData(projectFlowConfig.getName()).putAll(projectFlowConfig.getRequestData());
                    }
                })
                .deleteTable(new DeleteTable() {
                    @Override
                    public void beforeDelete(Condition condition, JSONObject amsListCondition) throws Exception {

                    }

                    @Override
                    public void afterDelete(Condition condition, JSONObject amsListCondition) throws Exception {
                        List<String> nameList = condition.addColumn("name").execute().getSingleColumnList(String.class);
                        for(String name:nameList){
                            quickFlow.getFlowConfig().flowConfigRequestDataMap.remove(name);
                        }
                    }
                })
        );
    }
}
